/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import org.luwrain.core.NullCheck;
import org.luwrain.core.Registry;

public final class RegistryUtils {
    public static String[] getStringArray(Registry registry, String path) {
        NullCheck.notNull((Object)registry, (String)"registry");
        NullCheck.notEmpty((Object)path, (String)"path");
        String[] ids = registry.getValues(path);
        if (ids.length == 0) {
            return new String[0];
        }
        int maxId = -1;
        for (String i : ids) {
            try {
                int v;
                if (registry.getTypeOf(Registry.join(path, i)) != 2 || (v = Integer.parseInt(i)) < 0 || maxId >= v) continue;
                maxId = v;
            }
            catch (NumberFormatException v) {
                // empty catch block
            }
        }
        if (maxId == -1) {
            return new String[0];
        }
        String[] res = new String[maxId + 1];
        for (String i : ids) {
            try {
                String value;
                int index;
                String fullPath = Registry.join(path, i);
                if (registry.getTypeOf(fullPath) != 2 || (index = Integer.parseInt(i)) < 0) continue;
                res[index] = value = registry.getString(fullPath);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return res;
    }

    public static void setStringArray(Registry registry, String path, String[] items) {
        NullCheck.notNull((Object)registry, (String)"registry");
        NullCheck.notEmpty((Object)path, (String)"path");
        NullCheck.notNullItems((Object[])items, (String)"items");
        registry.addDirectory(path);
        for (int i = 0; i < items.length; ++i) {
            Object index = String.valueOf(i);
            while (((String)index).length() < 3) {
                index = "0" + (String)index;
            }
            String fullPath = Registry.join(path, (String)index);
            registry.deleteValue(fullPath);
            registry.setString(fullPath, items[i]);
        }
    }
}

