/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.luwrain.core.NullCheck;

public final class UrlUtils {
    public static File urlToFile(String urlStr) {
        URL url;
        NullCheck.notEmpty((Object)urlStr, (String)"urlStr");
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (url.getProtocol() == null || !url.getProtocol().toLowerCase().equals("file")) {
            return null;
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    public static String fileToUrl(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        try {
            return file.toURI().toURL().toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

