/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.osm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.osm.App;
import org.luwrain.app.osm.Strings;
import org.luwrain.controls.ConsoleArea;
import org.luwrain.controls.console.ListModel;
import org.luwrain.core.Area;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Sounds;
import org.luwrain.io.api.osm.model.Element;

final class MainLayout
extends LayoutBase
implements ConsoleArea.Appearance<Element> {
    private final App app;
    final List<Element> elements = new ArrayList<Element>();
    final ConsoleArea<Element> consoleArea;

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.consoleArea = new ConsoleArea(this.consoleParams(p -> {
            p.model = new ListModel(this.elements);
            p.clickHandler = (area, index, el) -> this.onClick((Element)el);
            p.inputHandler = (area, text) -> this.onInput(text);
            p.appearance = this;
        }));
        this.setAreaLayout((Area)this.consoleArea, null);
    }

    boolean onClick(Element el) {
        return false;
    }

    ConsoleArea.InputHandler.Result onInput(String text) {
        if (text.isEmpty()) {
            return ConsoleArea.InputHandler.Result.REJECTED;
        }
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        if (this.app.runTask(taskId, () -> {
            List n = this.app.osm.findByName("node", text);
            this.app.finishedTask(taskId, () -> {
                this.elements.clear();
                if (n != null) {
                    this.elements.addAll(n);
                    this.getLuwrain().playSound(Sounds.DONE);
                } else {
                    this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.DONE, (String)((Strings)this.app.getStrings()).nothingFound()));
                }
                this.consoleArea.refresh();
            });
        })) {
            return ConsoleArea.InputHandler.Result.OK;
        }
        return ConsoleArea.InputHandler.Result.REJECTED;
    }

    public void announceItem(Element el) {
        String name;
        Map tags = el.getTags();
        if (tags != null && (name = (String)tags.get("name")) != null && !name.trim().isEmpty()) {
            this.app.setEventResponse(DefaultEventResponse.listItem((String)name));
        }
    }

    public String getTextAppearance(Element el) {
        Map tags = el.getTags();
        if (tags != null) {
            return Objects.requireNonNullElse((String)tags.get("name"), "");
        }
        return "";
    }
}

