/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander;

import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.commander.App;
import org.luwrain.app.commander.OperationsAppearance;
import org.luwrain.app.commander.Strings;
import org.luwrain.app.commander.fileops.Operation;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Area;
import org.luwrain.core.Sounds;

final class OperationsLayout
extends LayoutBase
implements ListArea.ClickHandler<Operation> {
    private final App app;
    final ListArea<Operation> operationsArea;

    OperationsLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.setCloseHandler(() -> {
            app.layouts().main();
            return true;
        });
        this.operationsArea = new ListArea<Operation>(this.listParams(params -> {
            params.name = ((Strings)app.getStrings()).operationsAreaName();
            params.clickHandler = this;
            params.model = new ListUtils.ListModel(app.operations);
            params.appearance = new OperationsAppearance(app);
        })){

            protected String noContentStr() {
                return "\u0424\u0430\u0439\u043b\u043e\u0432\u044b\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442";
            }
        };
        LayoutBase.Actions operationsActions = this.actions(new LayoutBase.ActionInfo[0]);
        this.setAreaLayout((Area)this.operationsArea, operationsActions);
    }

    public boolean onListClick(ListArea area, int index, Operation op) {
        this.app.operations.remove(index);
        this.operationsArea.refresh();
        this.app.getLuwrain().playSound(Sounds.OK);
        return true;
    }
}

