/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander.fileops;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.commander.fileops.CopyMoveParams;
import org.luwrain.app.commander.fileops.Operation;
import org.luwrain.app.commander.fileops.OperationCancelledException;
import org.luwrain.app.commander.fileops.OperationListener;
import org.luwrain.util.StreamUtils;

abstract class CopyingBase
extends Operation {
    private static final Logger log = LogManager.getLogger();
    private long totalBytes = 0L;
    private long processedBytes = 0L;
    private int percent = 0;
    private int lastPercent = 0;

    CopyingBase(OperationListener listener, String name) {
        super(listener, name);
    }

    @Override
    public int getPercent() {
        return this.percent;
    }

    protected void copy(CopyMoveParams params) throws IOException {
        Objects.requireNonNull(params, "params can't be null");
        Objects.requireNonNull(params.getSource(), "source can't be null");
        Objects.requireNonNull(params.getDest(), "dest can't be null");
        if (params.getSource().isEmpty()) {
            throw new IllegalArgumentException("source can't be empty");
        }
        for (Path p : params.getSource()) {
            Objects.requireNonNull(p, "p can't be null");
            if (p.isAbsolute()) continue;
            throw new IllegalArgumentException("Paths of all source files must be absolute");
        }
        this.totalBytes = 0L;
        for (Path f : params.getSource()) {
            log.trace("Calculating the size of " + String.valueOf(f));
            this.totalBytes += CopyingBase.getTotalSize(f);
        }
        log.trace("Total size is " + String.valueOf(this.totalBytes));
        Path d = params.getDest();
        if (!d.isAbsolute()) {
            Path parent = params.getSource().get(0).getParent();
            Objects.requireNonNull(parent, "parent can't be null");
            d = parent.resolve(d);
            log.trace("absolute destination path:" + d.toString());
        }
        for (Path path : params.getSource()) {
            if (!d.startsWith(path)) continue;
            throw new IOException("LWR_SOURCE_IS_A_PARENT_OF_THE_DEST");
        }
        if (params.getSource().size() == 1) {
            this.singleSource(params.getSource().get(0), d);
        } else {
            this.multipleSource(params.getSource(), d);
        }
    }

    private void singleSource(Path fileFrom, Path dest) throws IOException {
        log.trace("Single source mode:copying " + String.valueOf(fileFrom) + " to " + String.valueOf(dest));
        if (CopyingBase.isDirectory(dest, true)) {
            log.trace(String.valueOf(dest) + " exists and is a directory (or a symlink to a directory), copying the source file to it");
            this.copyRecurse(List.of(fileFrom), dest);
            return;
        }
        if (CopyingBase.isDirectory(fileFrom, false)) {
            log.trace(String.valueOf(fileFrom) + " is a directory and isn't a symlink");
            if (CopyingBase.exists(dest, false)) {
                switch (this.confirmOverwrite(dest)) {
                    case SKIP: {
                        return;
                    }
                    case CANCEL: {
                        throw new IOException("LWR_INTERRUPTED");
                    }
                }
                log.trace("Deleting previously existing " + dest.toString());
                Files.delete(dest);
            }
            Files.createDirectories(dest, new FileAttribute[0]);
            this.copyRecurse(Arrays.asList(CopyingBase.getDirContent(fileFrom)), dest);
            return;
        }
        if (!Files.isSymbolicLink(fileFrom) && !CopyingBase.isRegularFile(fileFrom, false)) {
            log.trace(String.valueOf(fileFrom) + "is not a symlink and is not a regular file, nothing to do");
            return;
        }
        log.trace(String.valueOf(fileFrom) + " is a symlink or a regular file");
        if (CopyingBase.exists(dest, false)) {
            log.trace(String.valueOf(dest) + " exists, trying to overwrite it");
            switch (this.confirmOverwrite(dest)) {
                case SKIP: {
                    return;
                }
                case CANCEL: {
                    throw new OperationCancelledException();
                }
            }
            Files.delete(dest);
        }
        if (dest.getParent() != null) {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        }
        this.copySingleFile(fileFrom, dest);
    }

    private void multipleSource(List<Path> toCopy, Path dest) throws IOException {
        log.trace("Multiple source mode");
        if (CopyingBase.exists(dest, false) && !CopyingBase.isDirectory(dest, true)) {
            log.trace(dest.toString() + " exists and is not a directory");
            switch (this.confirmOverwrite(dest)) {
                case SKIP: {
                    return;
                }
                case CANCEL: {
                    throw new OperationCancelledException();
                }
            }
            log.trace("Deleting previously existing " + dest.toString());
            Files.delete(dest);
        }
        if (!CopyingBase.exists(dest, false)) {
            Files.createDirectories(dest, new FileAttribute[0]);
        }
        this.copyRecurse(toCopy, dest);
    }

    private void copyRecurse(List<Path> filesFrom, Path fileTo) throws IOException {
        log.trace("CopyRecurse:copying " + filesFrom.size() + " entries to " + String.valueOf(fileTo));
        block4: for (Path f : filesFrom) {
            if (!CopyingBase.isDirectory(f, false)) {
                log.trace(f.toString() + " is not a directory, copying it");
                this.copyFileToDir(f, fileTo);
                continue;
            }
            log.trace(f.toString() + " is a directory");
            Path newDest = fileTo.resolve(f.getFileName());
            log.trace("New destination is " + newDest.toString());
            if (CopyingBase.exists(newDest, false) && !CopyingBase.isDirectory(newDest, true)) {
                log.trace(String.valueOf(newDest) + " already exists and isn't a directory, asking confirmation and trying to delete it");
                switch (this.confirmOverwrite(newDest)) {
                    case SKIP: {
                        continue block4;
                    }
                    case CANCEL: {
                        throw new OperationCancelledException();
                    }
                }
                this.status("deleting previously existing " + newDest.toString());
                Files.delete(newDest);
            }
            if (!CopyingBase.exists(newDest, false)) {
                Files.createDirectories(newDest, new FileAttribute[0]);
            }
            log.trace(String.valueOf(newDest) + " prepared");
            this.copyRecurse(Arrays.asList(CopyingBase.getDirContent(f)), newDest);
        }
    }

    private void copyFileToDir(Path file, Path destDir) throws IOException {
        Objects.requireNonNull(file, "file can't be null");
        Objects.requireNonNull(destDir, "destDir can't be null");
        this.copySingleFile(file, destDir.resolve(file.getFileName()));
    }

    private void copySingleFile(Path fromFile, Path toFile) throws IOException {
        Objects.requireNonNull(fromFile, "fromFile can't be null");
        Objects.requireNonNull(toFile, "toFile can't be null");
        if (CopyingBase.exists(toFile, false)) {
            log.trace(String.valueOf(toFile) + " already exists");
            switch (this.confirmOverwrite(toFile)) {
                case SKIP: {
                    return;
                }
                case CANCEL: {
                    throw new OperationCancelledException();
                }
            }
            Files.delete(toFile);
        }
        if (Files.isSymbolicLink(fromFile)) {
            Files.createSymbolicLink(toFile, Files.readSymbolicLink(fromFile), new FileAttribute[0]);
            return;
        }
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(fromFile, new OpenOption[0]));
             BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(toFile, new OpenOption[0]));){
            StreamUtils.copyAllBytes((InputStream)in, (OutputStream)out, (chunkNumBytes, totalNumBytes) -> this.onNewChunk(chunkNumBytes), () -> this.interrupted);
            out.flush();
            if (this.interrupted) {
                throw new IOException("INTERRUPTED");
            }
        }
    }

    private void onNewChunk(int bytes) {
        this.processedBytes += (long)bytes;
        long lPercent = this.processedBytes * 100L / this.totalBytes;
        this.percent = (int)lPercent;
        if (this.percent > this.lastPercent) {
            this.onProgress(this);
            this.lastPercent = this.percent;
        }
    }
}

