/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.luwrain.core.StarterCategory;
import org.luwrain.core.annotations.AppNoArgs;
import org.luwrain.core.annotations.ResourceStrings;

@SupportedAnnotationTypes(value={"org.luwrain.core.annotations.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@AutoService(value={Processor.class})
public class AnnotationProcessor
extends AbstractProcessor {
    private static final String LS = System.lineSeparator();
    private static final Pattern RE_I18N = Pattern.compile("([a-z]{2})=(.*)$");

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        block8: for (TypeElement typeElement : annotations) {
            switch (typeElement.getSimpleName().toString()) {
                case "AppNoArgs": {
                    for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                        this.write(element.toString() + "Extension", this.generateAppNoArgs(element));
                    }
                    continue block8;
                }
                case "ResourceStrings": {
                    for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                        this.write(element.toString() + "Extension", this.generateResourceStrings(element));
                    }
                    break;
                }
            }
        }
        return true;
    }

    String generateAppNoArgs(Element el) {
        AppNoArgs a = el.getAnnotation(AppNoArgs.class);
        if (a == null) {
            throw new IllegalStateException(el.toString() + " is not annotated with org.luwrain.core.annotations.AppNoArgs");
        }
        AppNoArgs app = a;
        String cl = el.toString();
        String simpleCl = cl.substring(cl.lastIndexOf(".") + 1);
        String newCl = simpleCl + "Extension";
        String pkg = cl.substring(0, cl.lastIndexOf("."));
        StringBuilder titles = new StringBuilder();
        if (app.title() != null) {
            for (String i : app.title()) {
                Matcher m = RE_I18N.matcher(i);
                if (!m.find()) {
                    throw new IllegalArgumentException("Illegal command title value: " + i);
                }
                titles.append("        i18n.addCommandTitle(\"").append(m.group(1)).append("\", \"").append(app.name()).append("\", \"").append(m.group(2)).append("\");").append(LS);
            }
        }
        Object starter = app.category() != null && app.category() != StarterCategory.NONE ? ", new DefaultStarter(\"command:" + app.name() + "\", StarterCategory." + app.category().toString() + ")" : "";
        return "package " + pkg + ";" + LS + "import org.luwrain.core.*;" + LS + "import com.google.auto .service.*;" + LS + "@AutoService(org.luwrain.core.Extension.class)" + LS + "public final class " + newCl + " extends org.luwrain.core.EmptyExtension {" + LS + "@Override public ExtensionObject[] getExtObjects(Luwrain luwrain) { return new ExtensionObject[] { new DefaultShortcut(\"" + app.name() + "\", " + simpleCl + ".class)" + (String)starter + " }; }" + LS + "@Override public Command[] getCommands(Luwrain luwrain) { return new Command[] { new SimpleShortcutCommand(\"" + app.name() + "\") }; }" + LS + "@Override public void i18nExtension(Luwrain luwrain, org.luwrain.i18n.I18nExtension i18n)" + LS + "{" + LS + new String(titles) + LS + "}" + LS + "}" + LS;
    }

    String generateResourceStrings(Element el) {
        ResourceStrings s = el.getAnnotation(ResourceStrings.class);
        if (s == null) {
            throw new IllegalStateException(el.toString() + " is not annotated with org.luwrain.core.annotations.ResourceStrings");
        }
        ResourceStrings str = s;
        String cl = el.toString();
        String simpleCl = cl.substring(cl.lastIndexOf(".") + 1);
        String newCl = simpleCl + "Extension";
        String pkg = cl.substring(0, cl.lastIndexOf("."));
        StringBuilder b = new StringBuilder();
        for (String l : str.langs()) {
            String resource = simpleCl + "-" + l + ".properties";
            b.append("i18n.addStrings(\"").append(l).append("\", ").append("\"").append(cl).append("\", ").append("new ResourceStringsObj(getClass().getClassLoader(), getClass(), \"").append(resource).append("\").create(\"").append(l).append("\", ").append(cl).append(".class));").append(LS);
        }
        return "// Generated automatically by " + this.getClass().getName() + LS + "package " + pkg + ";" + LS + "import org.luwrain.core.*;" + LS + "import org.luwrain.i18n.*;" + LS + "import org.apache.logging.log4j.*;" + LS + "import com.google.auto .service.*;" + LS + "@AutoService(org.luwrain.core.Extension.class)" + LS + "public final class " + newCl + " extends org.luwrain.core.EmptyExtension {" + LS + "static private final Logger log = LogManager.getLogger();" + LS + "@Override public void i18nExtension(Luwrain luwrain, org.luwrain.i18n.I18nExtension i18n)" + LS + "{" + LS + "try {" + LS + new String(b) + "}" + LS + "catch(Exception ex)" + LS + "{" + LS + "log.error(\"Unable to load a string resource file for the strings object " + cl + "\", ex);" + LS + "}" + LS + "}" + LS + "}" + LS;
    }

    void write(String className, String text) {
        try {
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(className, new Element[0]);
            try (PrintWriter out = new PrintWriter(file.openWriter());){
                out.println(text);
                out.flush();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

