/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.wifi;

import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.wifi.App;
import org.luwrain.app.wifi.Appearance;
import org.luwrain.app.wifi.Strings;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.SimpleArea;
import org.luwrain.core.Area;
import org.luwrain.core.Luwrain;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.linux.WifiNetwork;

final class MainLayout
extends LayoutBase
implements ListArea.ClickHandler<WifiNetwork> {
    private final App app;
    final ListArea<WifiNetwork> networksArea;
    final SimpleArea statusArea;

    MainLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        this.networksArea = new ListArea<WifiNetwork>(this.listParams(params -> {
            params.model = new ListUtils.ListModel(app.networks);
            params.name = ((Strings)app.getStrings()).networksAreaName();
            params.appearance = new Appearance(app);
            params.clickHandler = this;
        })){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case REFRESH: {
                            return app.updateNetworkList();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.statusArea = new SimpleArea(this.getControlContext(), ((Strings)app.getStrings()).statusAreaName());
        this.setAreaLayout((Area)this.networksArea, this.actions(new LayoutBase.ActionInfo[]{this.action("disconnect", ((Strings)app.getStrings()).actionDisconnect(), new InputEvent(InputEvent.Special.F5), this::actDisconnect, () -> this.findConnected() != null)}));
    }

    public boolean onListClick(ListArea area, int index, WifiNetwork network) {
        String password;
        WifiNetwork wifi = (WifiNetwork)this.networksArea.selected();
        if (wifi == null || this.app.isBusy()) {
            return false;
        }
        if (wifi.getProtectionType() != null && !wifi.getProtectionType().trim().isEmpty()) {
            password = this.app.getConv().askPassword();
            if (password == null) {
                return true;
            }
        } else {
            password = "";
        }
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            boolean res = this.app.nmCli.connect(wifi, password);
            if (!res) {
                this.app.finishedTask(taskId, () -> this.app.message(((Strings)this.app.getStrings()).errorConnecting(), Luwrain.MessageType.ERROR));
                return;
            }
            this.app.updateNetworksSync();
            this.app.finishedTask(taskId, () -> {
                this.networksArea.refresh();
                this.app.message(((Strings)this.app.getStrings()).connectionEstablished(), Luwrain.MessageType.DONE);
            });
        });
    }

    private boolean actDisconnect() {
        WifiNetwork wifi = this.findConnected();
        if (wifi == null) {
            return false;
        }
        if (!this.app.getConv().disconnectCurrent(wifi.getName())) {
            return true;
        }
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        return this.app.runTask(taskId, () -> {
            boolean res = this.app.nmCli.disconnect();
            this.app.finishedTask(taskId, () -> {
                if (res) {
                    this.app.message(((Strings)this.app.getStrings()).successfullyDisconnected(), Luwrain.MessageType.DONE);
                } else {
                    this.app.message(((Strings)this.app.getStrings()).errorDisconnecting(), Luwrain.MessageType.ERROR);
                }
            });
        });
    }

    private WifiNetwork findConnected() {
        int count = this.networksArea.getListModel().getItemCount();
        for (int i = 0; i < count; ++i) {
            if (!((WifiNetwork)this.networksArea.getListModel().getItem(i)).isConnected()) continue;
            return (WifiNetwork)this.networksArea.getListModel().getItem(i);
        }
        return null;
    }
}

