/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.NullCheck;

public final class BashProcess {
    private static final Logger log = LogManager.getLogger();
    private final String command;
    private final String dir;
    private final Set<Flags> flags;
    private final Listener listener;
    private Process p = null;
    private int pid = -1;
    private int exitCode = -1;
    private final ArrayList<String> output = new ArrayList();
    private final ArrayList<String> errors = new ArrayList();
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final AtomicBoolean doneOutput = new AtomicBoolean(false);
    private final AtomicBoolean doneErrors = new AtomicBoolean(false);

    public BashProcess(String command, String dir, Set<Flags> flags, Listener listener) {
        NullCheck.notEmpty((Object)command, (String)"command");
        NullCheck.notNull(flags, (String)"flags");
        NullCheck.notNull((Object)listener, (String)"listener");
        this.command = command;
        this.dir = dir != null ? dir : "/";
        this.flags = flags;
        this.listener = listener;
    }

    public BashProcess(String command, Set<Flags> flags, Listener listener) {
        this(command, null, flags, listener);
    }

    public BashProcess(String command, Set<Flags> flags) {
        this(command, flags, new EmptyListener());
    }

    public BashProcess(String command) {
        this(command, EnumSet.of(Flags.LOG_OUTPUT, Flags.LOG_ERRORS));
    }

    public void run() throws IOException {
        Object[] cmd = this.prepareCmd();
        log.debug("Running bash process: " + Arrays.toString(cmd));
        this.p = new ProcessBuilder((String[])cmd).start();
        this.p.getOutputStream().close();
        BufferedReader r = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        String pidStr = r.readLine();
        if (pidStr == null) {
            throw new IOException("Bash process didn't return its pid");
        }
        try {
            this.pid = Integer.parseInt(pidStr);
        }
        catch (NumberFormatException e) {
            log.error((Object)e);
            throw new IOException("'" + pidStr + "' is not a valid pid");
        }
        this.readOutput(r);
        this.readErrors(new BufferedReader(new InputStreamReader(this.p.getErrorStream())));
        new Thread(() -> {
            try {
                this.p.waitFor();
                this.exitCode = this.p.exitValue();
                AtomicBoolean atomicBoolean = this.done;
                synchronized (atomicBoolean) {
                    this.done.set(true);
                    this.done.notifyAll();
                }
                this.listener.onFinishing(this.exitCode);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public void stop() {
        try {
            if (this.flags.contains((Object)Flags.ROOT)) {
                new ProcessBuilder("sudo", "bash", "-c", "kill -KILL -" + String.valueOf(this.pid)).start();
            } else {
                new ProcessBuilder("bash", "-c", "kill -KILL -" + String.valueOf(this.pid)).start();
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() {
        try {
            AtomicBoolean atomicBoolean = this.done;
            synchronized (atomicBoolean) {
                while (!this.done.get()) {
                    this.done.wait();
                }
            }
            atomicBoolean = this.doneOutput;
            synchronized (atomicBoolean) {
                while (!this.doneOutput.get()) {
                    this.doneOutput.wait();
                }
            }
            atomicBoolean = this.doneErrors;
            synchronized (atomicBoolean) {
                while (!this.doneErrors.get()) {
                    this.doneErrors.wait();
                }
            }
            return this.exitCode;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    private String[] prepareCmd() {
        if (this.flags.contains((Object)Flags.ROOT)) {
            return new String[]{"sudo", "setsid", "/bin/bash", "-c", "echo $$; cd " + BashProcess.escape(this.dir) + "; " + this.command};
        }
        return new String[]{"setsid", "/bin/bash", "-c", "echo $$; cd " + BashProcess.escape(this.dir) + "; " + this.command};
    }

    private void readOutput(BufferedReader r) {
        boolean logOutput = this.flags.contains((Object)Flags.LOG_OUTPUT);
        new Thread(() -> {
            try {
                Object line;
                try {
                    line = r.readLine();
                    while (line != null) {
                        if (logOutput) {
                            this.output.add((String)line);
                        }
                        this.listener.onOutputLine((String)line);
                        line = r.readLine();
                    }
                }
                finally {
                    r.close();
                    line = this.doneOutput;
                    synchronized (line) {
                        this.doneOutput.set(true);
                        this.doneOutput.notifyAll();
                    }
                }
            }
            catch (IOException e) {
                log.error("Unable to read the output of the bash process '" + this.command, (Throwable)e);
            }
        }).start();
    }

    private void readErrors(BufferedReader r) {
        boolean logErrors = this.flags.contains((Object)Flags.LOG_OUTPUT);
        new Thread(() -> {
            try {
                Object line;
                try {
                    line = r.readLine();
                    while (line != null) {
                        if (logErrors) {
                            this.errors.add((String)line);
                        }
                        this.listener.onErrorLine((String)line);
                        line = r.readLine();
                    }
                }
                finally {
                    r.close();
                    line = this.doneErrors;
                    synchronized (line) {
                        this.doneErrors.set(true);
                        this.doneErrors.notifyAll();
                    }
                }
            }
            catch (IOException e) {
                log.error("Unable to read the errors of the bash process '" + this.command + "': ");
            }
        }).start();
    }

    public String[] getOutput() {
        return this.output.toArray(new String[this.output.size()]);
    }

    public String[] getErrors() {
        return this.errors.toArray(new String[this.errors.size()]);
    }

    public static String escape(String value) {
        return "'" + value.replaceAll("'", "'\\\\''") + "'";
    }

    public static interface Listener {
        public void onOutputLine(String var1);

        public void onErrorLine(String var1);

        public void onFinishing(int var1);
    }

    public static final class EmptyListener
    implements Listener {
        @Override
        public void onOutputLine(String line) {
        }

        @Override
        public void onErrorLine(String line) {
        }

        @Override
        public void onFinishing(int exitCode) {
        }
    }

    public static enum Flags {
        ROOT,
        LOG_OUTPUT,
        LOG_ERRORS;

    }
}

