/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import org.luwrain.core.NullCheck;

public class ConsoleReader {
    protected List<Item> items = new LinkedList<Item>();
    protected StringBuilder newText = new StringBuilder();

    public void read(Reader reader) throws IOException {
        NullCheck.notNull((Object)reader, (String)"reader");
        while (reader.ready()) {
            int c = reader.read();
            if (c == 27) {
                this.commit();
                this.onEscapeSeq(reader);
                continue;
            }
            if (Character.isISOControl(c)) {
                this.commit();
                this.onIsoControl(c);
                continue;
            }
            this.onRegularChar((char)c);
        }
    }

    protected void onRegularChar(char c) {
        this.newText.append(c);
    }

    protected void onIsoControl(int c) {
        switch (c) {
            case 7: {
                this.items.add(new Item(Item.Type.BELL));
                return;
            }
            case 10: {
                this.items.add(new Item(Item.Type.NEW_LINE));
                return;
            }
            case 8: {
                this.items.add(new Item(Item.Type.BACKSPACE));
                return;
            }
        }
    }

    protected void onEscapeSeq(Reader reader) throws IOException {
        NullCheck.notNull((Object)reader, (String)"reader");
        int c = reader.read();
        if (c < 0) {
            return;
        }
        if (c == 91) {
            c = reader.read();
            if (c < 0) {
                return;
            }
            if (c == 67) {
                this.items.add(new Item(Item.Type.KEY_RIGHT));
                return;
            }
        }
    }

    public void commit() {
        String text = new String(this.newText);
        if (!text.isEmpty()) {
            this.items.add(new Item(text));
        }
        this.newText = new StringBuilder();
    }

    public void clear() {
        this.newText = new StringBuilder();
        this.items.clear();
    }

    public Item[] getItems() {
        return this.items.toArray(new Item[this.items.size()]);
    }

    public static class Item {
        public final Type type;
        public final String text;

        public Item(Type type) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            this.type = type;
            this.text = null;
        }

        public Item(String text) {
            NullCheck.notNull((Object)text, (String)"text");
            this.type = Type.TEXT;
            this.text = text;
        }

        public String toString() {
            if (this.type == Type.TEXT && this.text != null) {
                return "[" + this.type.toString() + "] " + this.text;
            }
            return "[" + this.type.toString() + "]";
        }

        public static enum Type {
            TEXT,
            BELL,
            NEW_LINE,
            BACKSPACE,
            KEY_RIGHT;

        }
    }
}

