/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class PciIds {
    private static final Logger log = LogManager.getLogger();
    private static final Pattern VENDOR_PATTERN = Pattern.compile("^([^\\s]+)\\s+([^\\s].*)$");
    private static final Pattern CLASS_PATTERN = Pattern.compile("^C\\s*([^\\s]+)\\s+([^\\s].*)$");
    private static final Pattern DEVICE_PATTERN = Pattern.compile("^\t([^\\s]+)\\s+([^\\s].*)$");
    private final Map<String, Vendor> vendors = new TreeMap<String, Vendor>();
    private final Map<String, Class> classes = new TreeMap<String, Class>();
    private Vendor lastVendor = null;
    private Class lastClass = null;

    PciIds() {
    }

    String findVendor(String code) {
        Objects.requireNonNull(code, "code can't be null");
        if (code.isEmpty()) {
            throw new IllegalArgumentException("code can't be empty");
        }
        if (!this.vendors.containsKey(code)) {
            return null;
        }
        return this.vendors.get((Object)code).name;
    }

    String findDevice(String vendorCode, String deviceCode) {
        Objects.requireNonNull(vendorCode, "vendorCode can't be null");
        Objects.requireNonNull(deviceCode, "deviceCode can't be null");
        if (!this.vendors.containsKey(vendorCode)) {
            return null;
        }
        Vendor v = this.vendors.get(vendorCode);
        if (!v.devices.containsKey(deviceCode)) {
            return null;
        }
        return v.devices.get((Object)deviceCode).name;
    }

    String findClass(String classCode) {
        Objects.requireNonNull(classCode, "classCode can't be null");
        if (classCode.length() < 2) {
            return null;
        }
        if (!this.classes.containsKey(classCode.substring(0, 2))) {
            return null;
        }
        Class c = this.classes.get(classCode.substring(0, 2));
        return c.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(File file) {
        try (FileInputStream is = new FileInputStream(file);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.onLine(line);
            }
        }
        catch (Exception e) {
            log.error("Unable to read PCIIDs from", (Throwable)e);
        }
    }

    private void onVendor(String line) {
        Objects.requireNonNull(line, "line can't be null");
        Matcher matcher = VENDOR_PATTERN.matcher(line);
        if (!matcher.find()) {
            return;
        }
        Vendor v = new Vendor(matcher.group(2));
        this.vendors.put(matcher.group(1).trim(), v);
        this.lastVendor = v;
        this.lastClass = null;
    }

    private void onClass(String line) {
        Objects.requireNonNull(line, "line can't be null");
        Matcher matcher = CLASS_PATTERN.matcher(line);
        if (!matcher.find()) {
            return;
        }
        Class c = new Class(matcher.group(2));
        this.classes.put(matcher.group(1).trim(), c);
        this.lastVendor = null;
        this.lastClass = c;
    }

    private void onDevice(String line) {
        Objects.requireNonNull(line, "line can't be null");
        Matcher matcher = DEVICE_PATTERN.matcher(line);
        if (!matcher.find()) {
            return;
        }
        Device d = new Device(matcher.group(2));
        Objects.requireNonNull(this.lastVendor, "lastVendor can't be null");
        this.lastVendor.devices.put(matcher.group(1).trim(), d);
    }

    private void onLine(String line) {
        if (line.length() < 2 || line.charAt(0) == '#') {
            return;
        }
        if (Character.toLowerCase(line.charAt(0)) == 'c') {
            this.onClass(line);
        } else if (line.charAt(0) != '\t') {
            this.onVendor(line);
        } else if (this.lastVendor != null && line.charAt(1) != '\t') {
            this.onDevice(line);
        }
    }

    private static final class Vendor {
        final String name;
        final TreeMap<String, Device> devices = new TreeMap();

        Vendor(String name) {
            Objects.requireNonNull(name, "name can't be null");
            this.name = name;
        }
    }

    private static final class Class {
        final String name;
        final TreeMap<String, Subclass> subclasses = new TreeMap();

        Class(String name) {
            Objects.requireNonNull(name, "name can't be null");
            this.name = name;
        }
    }

    private static final class Device {
        final String name;

        Device(String name) {
            Objects.requireNonNull(name, "name can't be null");
            this.name = name;
        }
    }

    private static final class Subclass {
        final String name;

        Subclass(String name) {
            Objects.requireNonNull(name, "name can't be null");
            this.name = name;
        }
    }
}

