/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.speechd;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.speech.Channel;
import org.luwrain.speech.Voice;
import speechd.ssip.SSIPClient;
import speechd.ssip.SSIPEvent;
import speechd.ssip.SSIPEventHandler;
import speechd.ssip.SSIPPriority;

public final class Channel
implements org.luwrain.speech.Channel,
SSIPEventHandler {
    private static final Logger log = LogManager.getLogger();
    final SSIPClient client = new SSIPClient("LUWRAIN", null, null);
    private Channel.Listener listener = null;

    Channel(Map<String, String> params) throws Exception {
        if (this.client == null) {
            throw new Exception("Unable to create a speech dispatcher client");
        }
        if (params.containsKey("output")) {
            this.client.setOutputModule(params.get("output"));
        }
        if (params.containsKey("lang")) {
            this.client.setLanguage(params.get("lang"));
        }
        if (params.containsKey("voice")) {
            this.client.setVoice(params.get("voice"));
        }
        this.client.setNotification(true);
        this.client.setEventHandler(this);
    }

    @Override
    public void handleSSIPEvent(SSIPEvent event) {
        if (event == null || event.getType() == null) {
            return;
        }
        if (this.listener == null) {
            return;
        }
        switch (event.getType()) {
            case END: {
                this.listener.onFinished(-1L);
                this.listener = null;
                break;
            }
            default: {
                return;
            }
        }
    }

    public String getChannelName() {
        return "Speech dispatcher";
    }

    public String getVoiceName() {
        return "";
    }

    public void setVoice(String name) {
    }

    public Voice[] getVoices() {
        return new Voice[0];
    }

    public long speak(String text, Channel.Listener listener, int relPitch, int relRate, boolean cancelPrevious) {
        try {
            this.client.setPitch(relPitch * 2);
            this.client.setRate(-1 * relRate * 2);
            this.listener = listener;
            this.client.say(SSIPPriority.TEXT, text);
        }
        catch (Exception e) {
            log.error("Unable to speak a text", (Throwable)e);
        }
        return -1L;
    }

    public long speakLetter(char letter, Channel.Listener listener, int relPitch, int relRate, boolean cancelPrevious) {
        try {
            this.client.setPitch(relPitch * 2);
            this.client.setRate(-1 * relRate * 2);
            this.listener = listener;
            this.client.sayChar(SSIPPriority.TEXT, letter);
        }
        catch (Exception e) {
            log.error("Unable to speak a text", (Throwable)e);
        }
        return -1L;
    }

    public Channel.Result synth(String text, OutputStream stream, AudioFormat format, Channel.SyncParams params, Set<Channel.Flags> flags) {
        return new Channel.Result(Channel.Result.Type.NOT_IMPLEMENTED);
    }

    public AudioFormat[] getSynthSupportedFormats() {
        return new AudioFormat[0];
    }

    public void silence() {
        try {
            this.listener = null;
            this.client.stop();
        }
        catch (Exception e) {
            log.error("Unable to stop speaking", (Throwable)e);
        }
    }

    public void close() {
        try {
            this.listener = null;
            this.client.close();
        }
        catch (Exception e) {
            log.error("NABLE to close the connection", (Throwable)e);
        }
    }
}

