/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.browser;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.app.browser.WebLine;
import org.luwrain.controls.block.Block;
import org.luwrain.controls.block.BlockLine;
import org.luwrain.core.NullCheck;
import org.luwrain.web.WebKitBlock;
import org.luwrain.web.WebKitBlockBase;

final class WebBlock
implements Block {
    final int x;
    final int y;
    final int width;
    final ArrayList<WebLine> lines = new ArrayList();
    final WebKitBlock srcBlock;

    WebBlock(int x, int y, int width, List<WebLine> lines) {
        if (x < 0) {
            throw new IllegalArgumentException("x (" + x + ") can't be negative");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y (" + y + ") can't be negative");
        }
        if (width < 0) {
            throw new IllegalArgumentException("width (" + width + ") can't be negative");
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.lines.addAll(lines);
        this.srcBlock = null;
    }

    WebBlock(WebKitBlock srcBlock) {
        NullCheck.notNull((Object)srcBlock, (String)"srcBlock");
        this.x = srcBlock.getLeft();
        this.y = srcBlock.getTop();
        this.width = srcBlock.getWidth();
        this.lines.ensureCapacity(srcBlock.lines.size());
        srcBlock.lines.forEach(b -> this.lines.add(new WebLine((WebKitBlockBase.Line)b)));
        this.srcBlock = srcBlock;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getLineCount() {
        return this.lines.size();
    }

    @Override
    public BlockLine getLine(int index) {
        return this.lines.get(index);
    }
}

