/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.block.Block;
import org.luwrain.controls.block.BlockIterator;
import org.luwrain.controls.block.BlockLine;
import org.luwrain.controls.block.View;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

public class BlockArea
implements Area {
    static final String LOG_COMPONENT = "blocks";
    private static final int MIN_VISIBLE_WIDTH = 20;
    protected final ControlContext context;
    protected final Appearance appearance;
    protected ClickHandler clickHandler = null;
    protected View view = null;
    protected BlockIterator it = null;
    int hotPointX = 0;
    protected final List<Block> blocks = new ArrayList<Block>();

    public BlockArea(Params params) {
        NullCheck.notNull((Object)params, (String)"params");
        NullCheck.notNull((Object)params.context, (String)"params.context");
        NullCheck.notNull((Object)params.appearance, (String)"params.appearance");
        this.context = params.context;
        this.appearance = params.appearance;
        this.clickHandler = params.clickHandler;
    }

    public void clear() {
        this.view = null;
        this.it = null;
    }

    public void setBlocks(Block[] blocks) {
        NullCheck.notNull((Object)blocks, (String)LOG_COMPONENT);
        this.blocks.clear();
        this.blocks.addAll(Arrays.asList(blocks));
        this.view = new View(this.appearance, this.blocks);
        this.it = new BlockIterator(this);
        this.hotPointX = 0;
        this.context.onAreaNewContent((Area)this);
        this.context.onAreaNewHotPoint((Area)this);
        this.context.onAreaNewName((Area)this);
        Log.debug((String)LOG_COMPONENT, (String)("Setting " + this.blocks.size() + " blocks"));
    }

    public boolean isEmpty() {
        return this.view == null || this.it == null;
    }

    public int getHotPointX() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.it.getX() + this.hotPointX;
    }

    public int getHotPointY() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.it.getY();
    }

    public int getLineCount() {
        if (this.isEmpty()) {
            return 1;
        }
        return this.view.getLineCount();
    }

    public String getLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") may not be negative");
        }
        if (this.isEmpty()) {
            return index == 0 ? this.noContentStr() : "";
        }
        return this.view.getLine(index);
    }

    public String getAreaName() {
        return "FIXME";
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ENTER: {
                    return this.onClick();
                }
                case ARROW_RIGHT: {
                    return this.onMoveRight(event);
                }
                case ARROW_LEFT: {
                    return this.onMoveLeft(event);
                }
                case ARROW_DOWN: {
                    return this.onMoveDown(event);
                }
                case ARROW_UP: {
                    return this.onMoveUp(event);
                }
            }
        }
        return false;
    }

    protected boolean onClick() {
        if (this.isEmpty() || this.clickHandler == null) {
            return false;
        }
        return this.clickHandler.onClick(this, this.it.getBlock(), this.it.lineIndex, this.it.getBlock().getLine(this.it.lineIndex));
    }

    protected boolean onMoveRight(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.noContent()) {
            return true;
        }
        String text = this.it.getLineText(this.appearance);
        if (this.hotPointX >= text.length()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.END_OF_LINE));
            return true;
        }
        ++this.hotPointX;
        if (this.hotPointX >= text.length()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.END_OF_LINE));
            return true;
        }
        this.context.onAreaNewHotPoint((Area)this);
        this.context.setEventResponse(DefaultEventResponse.letter((char)text.charAt(this.hotPointX)));
        return true;
    }

    protected boolean onMoveLeft(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.noContent()) {
            return true;
        }
        String text = this.it.getLineText(this.appearance);
        if (this.hotPointX == 0) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.BEGIN_OF_LINE));
            return true;
        }
        --this.hotPointX;
        if (this.hotPointX >= text.length()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.END_OF_LINE));
            return true;
        }
        this.context.onAreaNewHotPoint((Area)this);
        this.context.setEventResponse(DefaultEventResponse.letter((char)text.charAt(this.hotPointX)));
        return true;
    }

    protected boolean onMoveUp(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.noContent()) {
            return true;
        }
        if (!this.it.movePrev()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.NO_ITEMS_ABOVE));
            return true;
        }
        this.hotPointX = 0;
        this.context.onAreaNewHotPoint((Area)this);
        this.announceRow();
        return true;
    }

    protected boolean onMoveDown(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.noContent()) {
            return true;
        }
        if (!this.it.moveNext()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.NO_ITEMS_BELOW));
            return true;
        }
        this.hotPointX = 0;
        this.context.onAreaNewHotPoint((Area)this);
        this.announceRow();
        return true;
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        return false;
    }

    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        return false;
    }

    public Action[] getAreaActions() {
        return new Action[0];
    }

    public void announceRow() {
        if (this.isEmpty()) {
            return;
        }
        if (this.it.lineIndex == 0) {
            this.appearance.announceFirstBlockLine(this.it.getBlock(), this.it.getLine());
        } else {
            this.appearance.announceBlockLine(this.it.getBlock(), this.it.getLine());
        }
    }

    protected String noContentStr() {
        return this.context.getStaticStr("NoContent");
    }

    protected void noContentMsg() {
        this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.NO_CONTENT));
    }

    protected boolean noContent() {
        if (this.isEmpty()) {
            this.noContentMsg();
            return true;
        }
        return false;
    }

    public static interface ClickHandler {
        public boolean onClick(BlockArea var1, Block var2, int var3, BlockLine var4);
    }

    public static class Params {
        public ControlContext context = null;
        public Appearance appearance;
        public ClickHandler clickHandler = null;
    }

    public static interface Appearance {
        public void announceFirstBlockLine(Block var1, BlockLine var2);

        public void announceBlockLine(Block var1, BlockLine var2);

        public String getBlockLineTextAppearance(Block var1, BlockLine var2);
    }
}

