/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.luwrain.core.NullCheck;
import org.luwrain.web.BlockGeom;

public class WebKitBlockBase
extends BlockGeom.Block {
    public String text = null;
    public final List<Run> runs = new ArrayList<Run>();
    public final List<Line> lines = new ArrayList<Line>();

    void buildLines() {
        for (Run r : this.runs) {
            this.lines.clear();
        }
        int availableWidth = this.right - this.left;
        if (availableWidth <= 0) {
            throw new IllegalStateException("The width of the block is equal to zero");
        }
        int spaceLeft = availableWidth;
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        for (Run r : this.runs) {
            int len = r.text.length();
            int[] breaks = r.getBreaks();
            int continueFrom = 0;
            while (continueFrom < len) {
                if (spaceLeft == 0) {
                    this.lines.add(new Line(fragments));
                    fragments.clear();
                    spaceLeft = availableWidth;
                    continue;
                }
                if (len - continueFrom <= spaceLeft) {
                    fragments.add(new Fragment(r, continueFrom, len));
                    spaceLeft -= len - continueFrom;
                    continueFrom = len;
                    continue;
                }
                if (breaks.length == 0) {
                    fragments.add(new Fragment(r, continueFrom, continueFrom + spaceLeft));
                    continueFrom += spaceLeft;
                    spaceLeft = 0;
                    continue;
                }
                int newBreak = this.findNextBreak(breaks, continueFrom, len, spaceLeft);
                if (newBreak < 0) {
                    if (spaceLeft == availableWidth) {
                        if (!fragments.isEmpty()) {
                            throw new IllegalStateException("having fragments without consumed space");
                        }
                        this.lines.add(new Line(Arrays.asList(new Fragment(r, continueFrom, continueFrom + spaceLeft))));
                        continueFrom += spaceLeft;
                        continue;
                    }
                    this.lines.add(new Line(fragments));
                    fragments.clear();
                    spaceLeft = availableWidth;
                    continue;
                }
                fragments.add(new Fragment(r, continueFrom, newBreak));
                spaceLeft -= newBreak - continueFrom;
                continueFrom = newBreak;
            }
        }
        if (!fragments.isEmpty()) {
            this.lines.add(new Line(fragments));
        }
        this.height = this.lines.size();
    }

    int findNextBreak(int[] breaks, int continueFrom, int wholeLen, int availableSpace) {
        int right;
        int left = 0;
        while (left + 1 < breaks.length && breaks[left + 1] <= continueFrom) {
            ++left;
        }
        for (right = breaks.length - 1; right > left && breaks[right] - continueFrom > availableSpace; --right) {
        }
        return right > left ? breaks[right] : -1;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getWidth() {
        return this.right - this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.top + this.lines.size();
    }

    public int getHeight() {
        return this.lines.size();
    }

    void stop() {
        throw new RuntimeException("Debug stop");
    }

    public static final class Run {
        public final String text;

        Run(String text) {
            NullCheck.notNull((Object)text, (String)"text");
            this.text = text;
        }

        int[] getBreaks() {
            ArrayList<Integer> res = new ArrayList<Integer>();
            for (int i = 1; i < this.text.length(); ++i) {
                char ch = this.text.charAt(i);
                char prevCh = this.text.charAt(i - 1);
                if (Character.isSpace(ch) || !Character.isSpace(prevCh)) continue;
                res.add(i);
            }
            int[] intRes = new int[res.size()];
            for (int i = 0; i < intRes.length; ++i) {
                intRes[i] = (Integer)res.get(i);
            }
            return intRes;
        }

        public String toString() {
            return this.text;
        }
    }

    public static final class Line {
        public final Fragment[] fragments;
        public final String text;

        Line(List<Fragment> fragments) {
            NullCheck.notNull(fragments, (String)"fragments");
            this.fragments = fragments.toArray(new Fragment[fragments.size()]);
            StringBuilder b = new StringBuilder();
            for (Fragment f : fragments) {
                b.append(f.text());
            }
            this.text = new String(b);
        }
    }

    public static final class Fragment {
        public final Run run;
        public final int fromPos;
        public final int toPos;

        Fragment(Run run, int fromPos, int toPos) {
            NullCheck.notNull((Object)run, (String)"run");
            if (fromPos < 0 || toPos < 0) {
                throw new IllegalArgumentException("fromPos (" + fromPos + ") and toPos (" + toPos + ") can't be negative");
            }
            if (fromPos > toPos) {
                throw new IllegalArgumentException("fromPos ( " + fromPos + ") must be less than toPos (" + toPos + ")");
            }
            if (toPos > run.text.length()) {
                throw new IllegalArgumentException("toPos (" + toPos + ") igreater than the length of the run text (" + run.text + ")");
            }
            this.run = run;
            this.fromPos = fromPos;
            this.toPos = toPos;
        }

        public String text() {
            return this.run.text.substring(this.fromPos, this.toPos);
        }

        public String toString() {
            return this.text();
        }
    }
}

