/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.mssapi;

public class SAPIImpl {
    public static final int SPF_DEFAULT = 0;
    public static final int SPF_ASYNC = 1;
    public static final int SPF_IS_XML = 8;
    public static final int SPF_IS_NOT_XML = 16;
    public static final int SPF_PURGEBEFORESPEAK = 2;
    private int id = idCounter++;
    private static int idCounter = 0;
    private String selectedVoiceId = null;
    private boolean isSpeaking = false;

    private native String getLastVoiceDescription();

    private native String getNextVoiceIdFromList();

    private native int selectCurrentVoice();

    private native int selectVoiceById(String var1);

    private native int searchVoiceByAttributes(String var1);

    private native int speak(String var1, int var2);

    private native int stream(String var1, int var2);

    private native int rate(int var1);

    private native int pitch(int var1);

    private native int wait(int var1);

    public void speakText(String text) {
        this.stopSpeaking();
        int result = this.speak(text, 17);
        if (result == 0) {
            this.isSpeaking = true;
        }
    }

    public void stopSpeaking() {
        if (this.isSpeaking) {
            this.speak("", 2);
            this.isSpeaking = false;
        }
    }

    public void setRate(int rate) {
        this.rate(rate);
    }

    public void setPitch(int pitch) {
        this.pitch(pitch);
    }

    public String[] getAvailableVoices() {
        int count = this.searchVoiceByAttributes(null);
        if (count <= 0) {
            return new String[0];
        }
        String[] voices = new String[count];
        for (int i = 0; i < count; ++i) {
            String id = this.getNextVoiceIdFromList();
            String desc = this.getLastVoiceDescription();
            voices[i] = desc + "|" + id;
        }
        return voices;
    }

    public boolean selectVoice(String voiceId) {
        if (this.selectVoiceById(voiceId) == 0) {
            this.selectedVoiceId = voiceId;
            return true;
        }
        return false;
    }

    public boolean selectFirstVoice() {
        String firstVoiceId;
        int count = this.searchVoiceByAttributes(null);
        if (count > 0 && this.selectVoiceById(firstVoiceId = this.getNextVoiceIdFromList()) == 0) {
            this.selectedVoiceId = firstVoiceId;
            return true;
        }
        return false;
    }

    public void waitUntilDone(int timeout) {
        this.wait(timeout);
    }

    public boolean setOutputToFile(String filename, int format) {
        return this.stream(filename, format) == 0;
    }

    public boolean setOutputToDefault() {
        return this.stream(null, 0) == 0;
    }

    public boolean isSpeaking() {
        return this.isSpeaking;
    }

    static {
        System.loadLibrary("SAPIImpl");
        System.out.println("\u2713 SAPI \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430");
    }
}

