/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.backends.java;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.Editing;
import org.luwrain.studio.Part;
import org.luwrain.studio.backends.java.Project;
import org.luwrain.studio.backends.java.SourceFile;

final class Folder
implements Part {
    @SerializedName(value="name")
    private String name = "";
    @SerializedName(value="subfolders")
    private List<Folder> subfolders = null;
    @SerializedName(value="sourceFiles")
    private List<SourceFile> sourceFiles = null;
    private Project proj = null;

    Folder() {
    }

    void setProject(Project proj) {
        NullCheck.notNull((Object)proj, (String)"proj");
        this.proj = proj;
        if (this.name == null) {
            this.name = "-";
        }
        if (this.subfolders == null) {
            this.subfolders = new ArrayList<Folder>();
        }
        if (this.sourceFiles == null) {
            this.sourceFiles = new ArrayList<SourceFile>();
        }
        for (Folder f : this.subfolders) {
            f.setProject(proj);
        }
    }

    @Override
    public Editing startEditing() {
        return null;
    }

    @Override
    public Part[] getChildParts() {
        ArrayList<Part> res = new ArrayList<Part>();
        for (Folder folder : this.subfolders) {
            res.add(folder);
        }
        for (SourceFile sourceFile : this.sourceFiles) {
            res.add(sourceFile);
        }
        return res.toArray(new Part[res.size()]);
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    public String toString() {
        return this.getTitle();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Folder;
    }

    @Override
    public Part.Action[] getActions() {
        return new Part.Action[0];
    }
}

