/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.backends.tex;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.popups.Popups;
import org.luwrain.studio.Editing;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.backends.tex.TexProject;
import org.luwrain.studio.backends.tex.TexSourceFile;

public final class TexFolder
implements Part {
    @SerializedName(value="name")
    private String name = "";
    @SerializedName(value="subfolders")
    private List<TexFolder> subfolders = null;
    @SerializedName(value="sourceFiles")
    private List<TexSourceFile> sourceFiles = null;
    private transient TexProject proj = null;
    private transient IDE ide = null;

    void init(TexProject proj, IDE ide) {
        NullCheck.notNull((Object)proj, (String)"proj");
        NullCheck.notNull((Object)ide, (String)"ide");
        this.proj = proj;
        this.ide = ide;
        if (this.name == null) {
            this.name = "-";
        }
        if (this.subfolders == null) {
            this.subfolders = new ArrayList<TexFolder>();
        }
        if (this.sourceFiles == null) {
            this.sourceFiles = new ArrayList<TexSourceFile>();
        }
        for (TexFolder texFolder : this.subfolders) {
            texFolder.init(proj, ide);
        }
        for (TexSourceFile texSourceFile : this.sourceFiles) {
            texSourceFile.init(proj, ide);
        }
    }

    @Override
    public Part[] getChildParts() {
        ArrayList<Part> res = new ArrayList<Part>();
        if (this.subfolders != null) {
            for (Part part : this.subfolders) {
                res.add(part);
            }
        }
        if (this.sourceFiles != null) {
            for (Part part : this.sourceFiles) {
                res.add(part);
            }
        }
        return res.toArray(new Part[res.size()]);
    }

    @Override
    public Editing startEditing() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        NullCheck.notEmpty((Object)name, (String)"name");
        this.name = name;
    }

    public List<TexFolder> getSubfolders() {
        return this.subfolders != null ? this.subfolders : new ArrayList<TexFolder>();
    }

    public void setSubfolders(List<TexFolder> subfolders) {
        NullCheck.notNull(subfolders, (String)"subfolders");
        this.subfolders = subfolders;
    }

    public List<TexSourceFile> getSourceFiles() {
        return this.sourceFiles != null ? this.sourceFiles : new ArrayList<TexSourceFile>();
    }

    public void setSourceFiles(List<TexSourceFile> sourceFiles) {
        NullCheck.notNull(sourceFiles, (String)"sourceFiles");
        this.sourceFiles = sourceFiles;
    }

    @Override
    public Part.Action[] getActions() {
        return Part.actions(Part.action("\u041d\u043e\u0432\u044b\u0439 \u0440\u0430\u0437\u0434\u0435\u043b", new InputEvent(InputEvent.Special.INSERT, EnumSet.of(InputEvent.Modifiers.CONTROL)), this::newSubfolder), Part.action("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0444\u0430\u0439\u043b", new InputEvent(InputEvent.Special.INSERT), this::newSourceFile));
    }

    private boolean newSubfolder(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        String name = Popups.textNotEmpty((Luwrain)ide.getLuwrainObj(), (String)this.proj.getStrings().newFolderPopupName(), (String)this.proj.getStrings().newFolderPopupPrefix(), (String)"");
        if (name == null || name.trim().isEmpty()) {
            return true;
        }
        TexFolder newFolder = new TexFolder();
        newFolder.setName(name.trim());
        newFolder.init(this.proj, ide);
        this.subfolders.add(newFolder);
        ide.onFoldersUpdate();
        return true;
    }

    private boolean newSourceFile(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        String name = Popups.textNotEmpty((Luwrain)ide.getLuwrainObj(), (String)"\u041d\u043e\u0432\u044b\u0439 \u0444\u0430\u0439\u043b", (String)"\u0418\u043c\u044f:", (String)"");
        if (name == null) {
            return true;
        }
        String path = Popups.textNotEmpty((Luwrain)ide.getLuwrainObj(), (String)"\u041d\u043e\u0432\u044b\u0439 \u0444\u0430\u0439\u043b", (String)"\u041f\u0443\u0442\u044c :", (String)"");
        if (path == null) {
            return true;
        }
        TexSourceFile newFile = new TexSourceFile(name, path);
        newFile.init(this.proj, ide);
        this.sourceFiles.add(newFile);
        ide.onFoldersUpdate();
        return true;
    }
}

