/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.indents.js;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Handler {
    private static final String BLOCK = "BlockContext";
    private static final String CLASS_BODY = "ClassTailContext";
    private static final String CLASS_EL = "ClassElementContext";
    private static final String FIELD = "FieldDefinitionContext";
    private static final String FUNC_EXP = "FunctionExpressionContext";
    private static final String FUNC_DECL = "FunctionDeclarationContext";
    private static final String FUNC_BODY = "FunctionBodyContext";
    private static final String SOURCE_EL = "SourceElementContext";
    private static final String STATEMENT = "StatementContext";
    final LinkedList<StackItem> stack = new LinkedList();
    final List<LineInfo> lines = new ArrayList<LineInfo>();
    int step = 4;

    void beginBlock(String type, int line, int pos) {
        StackItem tail;
        System.out.println("#" + type + " " + line + ", " + pos);
        while (this.lines.size() < line + 1) {
            this.lines.add(new LineInfo());
        }
        LineInfo lineInfo = this.lines.get(line);
        StackItem newStackItem = switch (type) {
            case STATEMENT, CLASS_EL -> new StackItem(type, line, pos);
            default -> null;
        };
        if (lineInfo.firstType == null && (type.equals(STATEMENT) || type.equals(CLASS_EL))) {
            lineInfo.firstType = type;
            lineInfo.firstStackItem = newStackItem;
            if (!this.stack.isEmpty()) {
                tail = this.stack.getLast();
                lineInfo.calcIndent = tail.prevStatementIndent >= 0 ? tail.prevStatementIndent : tail.pos + this.step;
                tail.prevStatementIndent = pos;
            }
        }
        if (newStackItem != null) {
            this.stack.add(newStackItem);
            return;
        }
        if (type.equals(FUNC_BODY) && lineInfo.firstType == null && !this.stack.isEmpty()) {
            lineInfo.firstType = FUNC_BODY;
            lineInfo.calcIndent = this.stack.getLast().pos;
            return;
        }
        if (type.equals(BLOCK) && !this.stack.isEmpty()) {
            tail = this.stack.getLast();
            if (tail.line == line && tail.pos == pos) {
                this.stack.pollLast();
                if (this.stack.isEmpty()) {
                    throw new IllegalStateException("No statement of the function in the stack");
                }
                this.stack.getLast().prevStatementIndent = -1;
                if (lineInfo.firstStackItem != null && lineInfo.firstStackItem.equals(tail)) {
                    lineInfo.calcIndent = this.stack.getLast().pos;
                    lineInfo.firstStackItem = null;
                }
            }
        }
    }

    void endBlock(String type, int endLine, int endPos, int startLine, int startPos) {
        while (this.lines.size() < endLine + 1) {
            this.lines.add(new LineInfo());
        }
        LineInfo lineInfo = this.lines.get(endLine);
        if (lineInfo.firstType == null && !this.stack.isEmpty() && (type.equals(FUNC_BODY) || type.equals(CLASS_BODY) || type.equals(BLOCK))) {
            lineInfo.calcIndent = this.stack.getLast().pos;
        }
        if (this.stack.isEmpty()) {
            return;
        }
        StackItem tail = this.stack.getLast();
        if (tail.type.equals(type) && tail.line == startLine && tail.pos == startPos) {
            this.stack.pollLast();
        }
    }

    public int getCalculatedIndent(int line) {
        if (line < 0 || line >= this.lines.size()) {
            return 0;
        }
        return this.lines.get((int)line).calcIndent;
    }

    static final class LineInfo {
        String firstType = null;
        StackItem firstStackItem = null;
        int calcIndent = 0;

        LineInfo() {
        }
    }

    static final class StackItem {
        final String type;
        final int line;
        final int pos;
        int prevStatementIndent = -1;

        StackItem(String type, int line, int pos) {
            this.type = type;
            this.line = line;
            this.pos = pos;
        }

        public boolean equals(Object o) {
            if (o instanceof StackItem) {
                StackItem s = (StackItem)o;
                return this.type.equals(s.type) && this.line == s.line && this.pos == s.pos;
            }
            return false;
        }
    }
}

