/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.proj;

import java.io.File;
import java.io.IOException;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.IDE;

public class ProjectBase {
    private transient File projDir = null;
    private transient File projFile = null;
    private transient IDE ide = null;

    protected void initBase(IDE ide, File projFile) {
        NullCheck.notNull((Object)ide, (String)"ide");
        NullCheck.notNull((Object)projFile, (String)"projFile");
        this.ide = ide;
        this.projFile = projFile;
        this.projDir = projFile.getParentFile();
        if (this.projDir == null) {
            this.projDir = new File(".");
        }
    }

    protected void findSourceFiles(File f, String suff) throws IOException {
        NullCheck.notNull((Object)f, (String)"f");
        NullCheck.notEmpty((Object)suff, (String)"suff");
        if (f.isDirectory()) {
            File[] items = f.listFiles();
            if (items != null) {
                for (File i : items) {
                    this.findSourceFiles(i, suff);
                }
            }
            return;
        }
        String name = f.getName();
        if (name.length() < suff.length() + 1 || !name.toUpperCase().endsWith(suff.toUpperCase())) {
            return;
        }
        this.readSourceFile(f);
    }

    protected void readSourceFile(File f) throws IOException {
    }

    public IDE getIde() {
        return this.ide;
    }

    public File getProjectDir() {
        return this.projDir;
    }

    public File getProjectFile() {
        return this.projFile;
    }
}

