/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.syntax;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.util.RangeUtils;

public final class SpanTree {
    final Span root = new Span();
    final List<Span> stack = new ArrayList<Span>();

    public SpanTree() {
        this.stack.add(this.root);
    }

    public Span addSpan() {
        Span newSpan = new Span();
        this.getLastInStack().children.add(newSpan);
        this.stack.add(newSpan);
        return newSpan;
    }

    public void pop() {
        if (this.stack.size() == 1) {
            throw new IllegalStateException("The root span can't be popped");
        }
        this.stack.remove(this.stack.size() - 1);
    }

    public Span[] findAtPoint(int pos) {
        ArrayList<Span> res = new ArrayList<Span>();
        this.findAtPoint(pos, this.root, res);
        return res.toArray(new Span[res.size()]);
    }

    private void findAtPoint(int pos, Span span, List<Span> res) {
        for (Span s : span.children) {
            if (!RangeUtils.between((int)pos, (int)s.fromPos, (int)s.toPos)) continue;
            res.add(s);
            this.findAtPoint(pos, s, res);
        }
    }

    public Span getCurrentSpan() {
        return this.getLastInStack();
    }

    private Span getLastInStack() {
        return this.stack.get(this.stack.size() - 1);
    }

    public static final class Span {
        List<Span> children = new ArrayList<Span>();
        int fromPos = 0;
        int toPos = 0;

        public int getFromPos() {
            return this.fromPos;
        }

        public int getToPos() {
            return this.toPos;
        }

        public void setFromPos(int fromPos) {
            if (fromPos < 0) {
                throw new IllegalArgumentException("fromPos can't be negative");
            }
            this.fromPos = fromPos;
        }

        public void setToPos(int toPos) {
            if (toPos < 0) {
                throw new IllegalArgumentException("toPos can't be negative");
            }
            this.toPos = toPos;
        }
    }
}

