/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.syntax.java;

import org.luwrain.core.NullCheck;
import org.luwrain.studio.syntax.IndentUtils;
import org.luwrain.studio.syntax.Source;
import org.luwrain.studio.syntax.SpanTree;
import org.luwrain.studio.syntax.SyntaxParams;

public final class JavaIndent {
    final Source source;
    final SpanTree spanTree;
    final SyntaxParams params;
    final IndentUtils utils;

    public JavaIndent(Source source, SpanTree spanTree, SyntaxParams params) {
        NullCheck.notNull((Object)source, (String)"source");
        NullCheck.notNull((Object)spanTree, (String)"spanTree");
        NullCheck.notNull((Object)params, (String)"params");
        this.source = source;
        this.spanTree = spanTree;
        this.params = params;
        this.utils = new IndentUtils(params);
    }

    public int getIndentForLine(int lineIndex) {
        int baseIndex;
        SpanTree.Span lastSpan;
        if (lineIndex > this.source.getLineCount()) {
            throw new IllegalArgumentException("lineIndex can't be greater than number of lines");
        }
        System.out.println("proba " + this.source.getLine(lineIndex));
        int lineStart = this.source.getLineStart(lineIndex);
        SpanTree.Span[] spans = this.spanTree.findAtPoint(lineStart);
        SpanTree.Span span = spans.length > 0 ? (lineStart == (lastSpan = spans[spans.length - 1]).getFromPos() ? (spans.length >= 2 ? spans[spans.length - 2] : null) : lastSpan) : null;
        int spanStart = span != null ? span.getFromPos() : 0;
        System.out.println(lineStart + " " + spanStart);
        System.out.println(this.source.getText().charAt(spanStart));
        int spanStartLine = this.source.getLineWithPos(spanStart);
        System.out.println("spanStartLine=" + spanStartLine);
        if (span != null && this.isEmptyFragment(spanStart + 1, lineStart)) {
            System.out.println("nothing between");
            String line = this.source.getLine(spanStartLine);
            System.out.println(line);
            return this.utils.getIndent(line) + this.params.getIndentStep();
        }
        for (baseIndex = lineIndex - 1; baseIndex >= 0 && this.source.getLine(baseIndex).trim().isEmpty(); --baseIndex) {
        }
        if (baseIndex < 0) {
            return 0;
        }
        return this.utils.getIndent(this.source.getLine(baseIndex));
    }

    private boolean isEmptyFragment(int fromPos, int toPos) {
        String text = this.source.getText();
        for (int i = fromPos; i < toPos; ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

