/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import com.vk.api.sdk.exceptions.ApiException;
import com.vk.api.sdk.exceptions.ClientException;
import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.friends.responses.DeleteResponse;
import com.vk.api.sdk.objects.friends.responses.GetRequestsResponse;
import com.vk.api.sdk.objects.friends.responses.GetResponse;
import com.vk.api.sdk.objects.friends.responses.GetSuggestionsResponse;
import com.vk.api.sdk.objects.messages.ConversationWithMessage;
import com.vk.api.sdk.objects.messages.Message;
import com.vk.api.sdk.objects.messages.responses.GetConversationsResponse;
import com.vk.api.sdk.objects.messages.responses.GetHistoryResponse;
import com.vk.api.sdk.objects.photos.responses.GetWallUploadServerResponse;
import com.vk.api.sdk.objects.photos.responses.SaveWallPhotoResponse;
import com.vk.api.sdk.objects.photos.responses.WallUploadResponse;
import com.vk.api.sdk.objects.users.Fields;
import com.vk.api.sdk.objects.users.UserFull;
import com.vk.api.sdk.objects.users.responses.SearchResponse;
import com.vk.api.sdk.objects.wall.WallpostFull;
import com.vk.api.sdk.objects.wall.responses.PostResponse;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.luwrain.app.vk.ActionLists;
import org.luwrain.app.vk.App;
import org.luwrain.app.vk.Base;
import org.luwrain.app.vk.Conversations;
import org.luwrain.app.vk.Strings;
import org.luwrain.app.vk.TaskCancelling;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

final class Actions {
    static final int ANSWER_LIMIT = 100;
    private final Luwrain luwrain;
    private final Strings strings;
    private final Base base;
    private final App app;
    final Conversations conv;
    final ActionLists lists;

    Actions(Base base, App app) {
        NullCheck.notNull((Object)base, (String)"base");
        NullCheck.notNull((Object)app, (String)"app");
        this.luwrain = base.luwrain;
        this.strings = base.strings;
        this.base = base;
        this.conv = new Conversations(this.luwrain, this.strings);
        this.lists = new ActionLists(this.luwrain, this.strings, base);
        this.app = app;
    }

    boolean onHomeWallUpdate(Runnable onSuccess) {
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            com.vk.api.sdk.objects.wall.responses.GetResponse resp = (com.vk.api.sdk.objects.wall.responses.GetResponse)this.base.vk.wall().get(this.base.actor).execute();
            this.base.acceptTaskResult(taskId, () -> {
                List list = resp.getItems();
                this.base.wallPosts = list.toArray(new WallpostFull[list.size()]);
                onSuccess.run();
            });
        });
    }

    boolean onUserInfoUpdate(int userId, Runnable onSuccess) {
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            List userResp = (List)this.base.vk.users().get(this.base.actor).userIds(new String[]{Integer.valueOf(userId).toString()}).fields(new Fields[]{Fields.STATUS, Fields.LAST_SEEN, Fields.OCCUPATION, Fields.INTERESTS, Fields.BDATE}).execute();
            if (userResp.isEmpty()) {
                return;
            }
            UserFull shownUser = (UserFull)userResp.get(0);
            com.vk.api.sdk.objects.wall.responses.GetResponse resp = (com.vk.api.sdk.objects.wall.responses.GetResponse)this.base.vk.wall().get(this.base.actor).ownerId(Integer.valueOf(userId)).count(Integer.valueOf(30)).execute();
            this.base.acceptTaskResult(taskId, () -> {
                this.base.shownUser = shownUser;
                List list = resp.getItems();
                this.base.shownUserWallPosts = list.toArray(new WallpostFull[list.size()]);
                onSuccess.run();
            });
        });
    }

    boolean onWallDelete(WallpostFull post, Runnable onSuccess) {
        NullCheck.notNull((Object)post, (String)"post");
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            this.base.vk.wall().delete(this.base.actor).postId(post.getId()).execute();
            com.vk.api.sdk.objects.wall.responses.GetResponse resp = (com.vk.api.sdk.objects.wall.responses.GetResponse)this.base.vk.wall().get(this.base.actor).execute();
            this.base.acceptTaskResult(taskId, () -> {
                List list = resp.getItems();
                this.base.wallPosts = list.toArray(new WallpostFull[list.size()]);
                onSuccess.run();
            });
        });
    }

    boolean onWallPost(String text, File[] photos, Runnable onSuccess) {
        NullCheck.notEmpty((Object)text, (String)"text");
        NullCheck.notNullItems((Object[])photos, (String)"photos");
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            LinkedList<CallSite> attachments = new LinkedList<CallSite>();
            for (File f : photos) {
                GetWallUploadServerResponse server = (GetWallUploadServerResponse)this.base.vk.photos().getWallUploadServer(this.base.actor).execute();
                WallUploadResponse upload = (WallUploadResponse)this.base.vk.upload().photoWall(server.getUploadUrl().toString(), f).execute();
                for (SaveWallPhotoResponse p : (List)this.base.vk.photos().saveWallPhoto(this.base.actor, upload.getPhoto()).server(upload.getServer()).hash(upload.getHash()).execute()) {
                    attachments.add((CallSite)((Object)("photo" + p.getOwnerId() + "_" + p.getId())));
                }
            }
            PostResponse resp = (PostResponse)this.base.vk.wall().post(this.base.actor).message(text).attachments(attachments).execute();
            com.vk.api.sdk.objects.wall.responses.GetResponse respPosts = (com.vk.api.sdk.objects.wall.responses.GetResponse)this.base.vk.wall().get(this.base.actor).execute();
            this.base.acceptTaskResult(taskId, () -> {
                List list = respPosts.getItems();
                this.base.wallPosts = list.toArray(new WallpostFull[list.size()]);
                onSuccess.run();
            });
        });
    }

    boolean onConversationsUpdate(Runnable onSuccess) {
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            GetConversationsResponse resp = (GetConversationsResponse)this.base.vk.messages().getConversations(this.base.actor).execute();
            List list = resp.getItems();
            ArrayList<String> userIds = new ArrayList<String>();
            for (ConversationWithMessage d : list) {
                userIds.add(d.getLastMessage().getFromId().toString());
                userIds.add(d.getLastMessage().getPeerId().toString());
            }
            UserFull[] users = this.getUsersForCache(userIds);
            this.base.acceptTaskResult(taskId, () -> {
                this.base.conversations = list.toArray(new ConversationWithMessage[list.size()]);
                this.base.cacheUsers(users);
                onSuccess.run();
            });
        });
    }

    void onConversationsUpdateNonInteractive(Runnable onSuccess) {
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        this.luwrain.executeBkg(new FutureTask<Object>(() -> {
            try {
                GetConversationsResponse resp = (GetConversationsResponse)this.base.vk.messages().getConversations(this.base.actor).execute();
                List list = resp.getItems();
                ArrayList<String> userIds = new ArrayList<String>();
                for (ConversationWithMessage d : list) {
                    userIds.add(d.getLastMessage().getFromId().toString());
                }
                UserFull[] users = this.getUsersForCache(userIds);
                this.luwrain.runUiSafely(() -> {
                    this.base.conversations = list.toArray(new ConversationWithMessage[list.size()]);
                    this.base.cacheUsers(users);
                    onSuccess.run();
                });
                return;
            }
            catch (Exception e) {
                this.base.onTaskError(e);
                return;
            }
        }, null));
    }

    boolean onMessagesHistory(ConversationWithMessage conv, Runnable onSuccess) {
        NullCheck.notNull((Object)conv, (String)"conv");
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        Message message = conv.getLastMessage();
        if (message == null) {
            return false;
        }
        int peerId = message.getOut() == BoolInt.YES ? message.getPeerId().intValue() : message.getFromId().intValue();
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            this.base.vk.messages().markAsRead(this.base.actor).peerId(Integer.valueOf(peerId)).startMessageId(message.getId()).execute();
            GetHistoryResponse resp = (GetHistoryResponse)this.base.vk.messages().getHistory(this.base.actor).userId(Integer.valueOf(peerId)).execute();
            this.base.acceptTaskResult(taskId, () -> {
                List list = resp.getItems();
                this.base.messages = list.toArray(new Message[list.size()]);
                onSuccess.run();
            });
        });
    }

    void onMessagesHistoryNonInteractive(int userId, Runnable onSuccess) {
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        this.luwrain.executeBkg(new FutureTask<Object>(() -> {
            try {
                GetHistoryResponse resp = (GetHistoryResponse)this.base.vk.messages().getHistory(this.base.actor).userId(Integer.valueOf(userId)).execute();
                this.luwrain.runUiSafely(() -> {
                    List list = resp.getItems();
                    this.base.messages = list.toArray(new Message[list.size()]);
                    onSuccess.run();
                });
                return;
            }
            catch (Exception e) {
                this.base.onTaskError(e);
                return;
            }
        }, null));
    }

    boolean onMessageSend(int userId, String text, Runnable onSuccess) {
        NullCheck.notEmpty((Object)text, (String)"text");
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            this.base.vk.messages().send(this.base.actor).message(text).randomId(Integer.valueOf(this.base.nextRandomId())).peerId(Integer.valueOf(userId)).execute();
            GetHistoryResponse resp = (GetHistoryResponse)this.base.vk.messages().getHistory(this.base.actor).userId(Integer.valueOf(userId)).execute();
            this.base.acceptTaskResult(taskId, () -> {
                List list = resp.getItems();
                this.base.messages = list.toArray(new Message[list.size()]);
                onSuccess.run();
            });
        });
    }

    boolean onUsersSearch(String query, Runnable onSuccess) {
        NullCheck.notEmpty((Object)query, (String)"query");
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            if (query.trim().toLowerCase().matches("id[0-9]+")) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(query.trim().substring(2));
                List resp = (List)this.base.vk.users().get(this.base.actor).userIds(ids).fields(new Fields[]{Fields.STATUS, Fields.CITY, Fields.LAST_SEEN}).execute();
                this.base.acceptTaskResult(taskId, () -> {
                    this.base.users = resp.toArray(new UserFull[resp.size()]);
                    onSuccess.run();
                });
                return;
            }
            SearchResponse resp = (SearchResponse)this.base.vk.users().search(this.base.actor).q(query).offset(Integer.valueOf(0)).count(Integer.valueOf(100)).fields(new Fields[]{Fields.STATUS, Fields.CITY, Fields.LAST_SEEN}).execute();
            this.base.acceptTaskResult(taskId, () -> {
                List list = resp.getItems();
                this.base.users = list.toArray(new UserFull[list.size()]);
                onSuccess.run();
            });
        });
    }

    boolean onFriendshipRequestsUpdate(Runnable onSuccess) {
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            GetResponse friendsResp = (GetResponse)this.base.vk.friends().get(this.base.actor).execute();
            List friendsList = friendsResp.getItems();
            Integer[] friendsIds = friendsList.toArray(new Integer[friendsList.size()]);
            UserFull[] friendsUsers = this.getUsersForCache(friendsIds);
            GetRequestsResponse requestsResp = (GetRequestsResponse)this.base.vk.friends().getRequests(this.base.actor).execute();
            List requestsList = requestsResp.getItems();
            Integer[] requestsIds = requestsList.toArray(new Integer[requestsList.size()]);
            UserFull[] requestsUsers = this.getUsersForCache(requestsIds);
            this.base.acceptTaskResult(taskId, () -> {
                this.base.friends = friendsUsers;
                this.base.friendshipRequests = requestsUsers;
                onSuccess.run();
            });
        });
    }

    boolean onFollowingsUpdate(Runnable onSuccess) {
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            GetRequestsResponse requestsResp = (GetRequestsResponse)this.base.vk.friends().getRequests(this.base.actor).out(Boolean.valueOf(true)).execute();
            List requestsList = requestsResp.getItems();
            Integer[] requestsIds = requestsList.toArray(new Integer[requestsList.size()]);
            UserFull[] requestsUsers = this.getUsersForCache(requestsIds);
            GetSuggestionsResponse resp = (GetSuggestionsResponse)this.base.vk.friends().getSuggestions(this.base.actor).execute();
            List list = resp.getItems();
            this.base.acceptTaskResult(taskId, () -> {
                this.base.followings = requestsUsers;
                this.base.suggestions = list.toArray(new UserFull[list.size()]);
                onSuccess.run();
            });
        });
    }

    boolean onFriendshipDelete(int userId, Runnable onSuccess) {
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            DeleteResponse deleteResp = (DeleteResponse)this.base.vk.friends().delete(this.base.actor).userId(Integer.valueOf(userId)).execute();
            GetRequestsResponse requestsResp = (GetRequestsResponse)this.base.vk.friends().getRequests(this.base.actor).out(Boolean.valueOf(true)).execute();
            List requestsList = requestsResp.getItems();
            Integer[] requestsIds = requestsList.toArray(new Integer[requestsList.size()]);
            UserFull[] requestsUsers = this.getUsersForCache(requestsIds);
            GetSuggestionsResponse resp = (GetSuggestionsResponse)this.base.vk.friends().getSuggestions(this.base.actor).execute();
            List list = resp.getItems();
            this.base.acceptTaskResult(taskId, () -> {
                this.base.followings = requestsUsers;
                this.base.suggestions = list.toArray(new UserFull[list.size()]);
                onSuccess.run();
            });
        });
    }

    boolean onNewFriendship(int userId, Runnable onSuccess) {
        NullCheck.notNull((Object)onSuccess, (String)"onSuccess");
        TaskCancelling.TaskId taskId = this.base.taskCancelling.newTaskId();
        return this.base.runBkg(() -> {
            this.base.vk.friends().add(this.base.actor).userId(Integer.valueOf(userId)).execute();
            GetResponse friendsResp = (GetResponse)this.base.vk.friends().get(this.base.actor).execute();
            List friendsList = friendsResp.getItems();
            Integer[] friendsIds = friendsList.toArray(new Integer[friendsList.size()]);
            UserFull[] friendsUsers = this.getUsersForCache(friendsIds);
            GetRequestsResponse requestsResp = (GetRequestsResponse)this.base.vk.friends().getRequests(this.base.actor).execute();
            List requestsList = requestsResp.getItems();
            Integer[] requestsIds = requestsList.toArray(new Integer[requestsList.size()]);
            UserFull[] requestsUsers = this.getUsersForCache(requestsIds);
            this.base.acceptTaskResult(taskId, () -> {
                this.base.friends = friendsUsers;
                this.base.friendshipRequests = requestsUsers;
                onSuccess.run();
            });
        });
    }

    boolean onNewsfeedUpdate(Runnable onSuccess) {
        return false;
    }

    private UserFull[] getUsersForCache(Integer[] ids) throws ApiException, ClientException {
        ArrayList<String> list = new ArrayList<String>();
        for (Integer i : ids) {
            list.add(i.toString());
        }
        return this.getUsersForCache(list);
    }

    private UserFull[] getUsersForCache(List<String> ids) throws ApiException, ClientException {
        List resp = (List)this.base.vk.users().get(this.base.actor).userIds(ids).fields(new Fields[]{Fields.STATUS, Fields.LAST_SEEN, Fields.CITY, Fields.BDATE}).execute();
        return resp.toArray(new UserFull[resp.size()]);
    }
}

