/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import com.vk.api.sdk.objects.users.UserFull;
import org.luwrain.app.vk.ActionLists;
import org.luwrain.app.vk.Actions;
import org.luwrain.app.vk.Base;
import org.luwrain.app.vk.ConversationsArea;
import org.luwrain.app.vk.FollowingsArea;
import org.luwrain.app.vk.FriendsArea;
import org.luwrain.app.vk.FriendshipRequestsArea;
import org.luwrain.app.vk.MessagesArea;
import org.luwrain.app.vk.Strings;
import org.luwrain.app.vk.SuggestionsArea;
import org.luwrain.app.vk.UsersArea;
import org.luwrain.app.vk.WallArea;
import org.luwrain.app.vk.WallPostArea;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.AreaLayoutHelper;
import org.luwrain.core.Event;
import org.luwrain.core.InitResult;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MonoApp;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

public class App
implements Application,
MonoApp {
    private Luwrain luwrain = null;
    private Strings strings = null;
    private Base base = null;
    private Actions actions = null;
    private ActionLists actionLists = null;
    private WallArea defaultArea = null;
    private AreaLayoutHelper layout = null;

    public InitResult onLaunchApp(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        Object o = luwrain.i18n().getStrings(Strings.class.getName());
        if (o == null || !(o instanceof Strings)) {
            return new InitResult(InitResult.Type.NO_STRINGS_OBJ, Strings.class.getName());
        }
        this.strings = (Strings)o;
        this.luwrain = luwrain;
        this.base = new Base(luwrain, this.strings);
        this.actions = new Actions(this.base, this);
        this.actionLists = new ActionLists(luwrain, this.strings, this.base);
        this.createDefaultArea();
        this.base.setVisibleAreas(new Area[]{this.defaultArea});
        this.layout = new AreaLayoutHelper(() -> {
            this.base.setVisibleAreas(this.layout.getLayout().getAreas());
            luwrain.onNewAreaLayout();
        }, new AreaLayout((Area)this.defaultArea));
        return new InitResult();
    }

    public void closeApp() {
        this.base.closeApp();
    }

    public void onAppClose() {
    }

    public AreaLayout getAreaLayout() {
        return this.layout.getLayout();
    }

    public String getAppName() {
        return this.strings.appName();
    }

    private void createDefaultArea() {
        this.defaultArea = new WallArea(this.luwrain, this.strings, this.base, this.actions){

            @Override
            public boolean onInputEvent(InputEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.isSpecial() && !event.isModified()) {
                    switch (event.getSpecial()) {
                        case TAB: {
                            Area[] areas = App.this.layout.getLayout().getAreas();
                            if (areas.length > 1) {
                                App.this.luwrain.setActiveArea(areas[1]);
                                return true;
                            }
                            return false;
                        }
                    }
                }
                return super.onInputEvent(event);
            }

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                switch (event.getCode()) {
                    case ACTION: {
                        if (ActionEvent.isAction((Event)event, (String)"conversations")) {
                            return App.this.onShowConversations();
                        }
                        if (ActionEvent.isAction((Event)event, (String)"friends")) {
                            return App.this.onShowFriends();
                        }
                        if (ActionEvent.isAction((Event)event, (String)"post")) {
                            return App.this.onNewWallPost(this);
                        }
                        if (ActionEvent.isAction((Event)event, (String)"news")) {
                            return App.this.actions.onNewsfeedUpdate(() -> {});
                        }
                        if (ActionEvent.isAction((Event)event, (String)"followings")) {
                            return App.this.onShowFollowings();
                        }
                        if (ActionEvent.isAction((Event)event, (String)"users")) {
                            return App.this.onShowUsers();
                        }
                        return super.onSystemEvent(event);
                    }
                }
                return super.onSystemEvent(event);
            }
        };
    }

    private boolean onNewWallPost(WallArea wallArea) {
        NullCheck.notNull((Object)((Object)wallArea), (String)"wallArea");
        this.layout.openTempArea((Area)new WallPostArea(this.luwrain, this.strings, this.base, this.actions, this.actionLists, () -> {
            this.layout.closeTempLayout();
            this.luwrain.announceActiveArea();
            wallArea.refresh();
        }));
        this.luwrain.announceActiveArea();
        return true;
    }

    private boolean onShowConversations() {
        Runnable closing = () -> {
            this.layout.setBasicLayout(new AreaLayout((Area)this.defaultArea));
            this.luwrain.announceActiveArea();
        };
        ConversationsArea conversationsArea = new ConversationsArea(this.base, this.actions, closing);
        MessagesArea messagesArea = new MessagesArea(this.luwrain, this.strings, this.base, this.actions, closing);
        this.layout.setBasicLayout(new AreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.defaultArea, (Area)conversationsArea, (Area)messagesArea));
        conversationsArea.setMessagesArea(messagesArea);
        messagesArea.setConversationsArea(conversationsArea);
        conversationsArea.setDefaultArea((Area)this.defaultArea);
        messagesArea.setDefaultArea((Area)this.defaultArea);
        return true;
    }

    private boolean onShowFriends() {
        Runnable closing = () -> {
            this.layout.setBasicLayout(new AreaLayout((Area)this.defaultArea));
            this.luwrain.announceActiveArea();
        };
        FriendsArea friendsArea = new FriendsArea(this.luwrain, this.strings, this.base, this.actions, closing){

            @Override
            boolean onClick(UserFull user) {
                NullCheck.notNull((Object)user, (String)"user");
                return App.this.defaultArea.showUserInfo(user.getId());
            }
        };
        FriendshipRequestsArea friendshipRequestsArea = new FriendshipRequestsArea(this.luwrain, this.strings, this.base, this.actions, closing){

            @Override
            boolean onProperties(UserFull user) {
                NullCheck.notNull((Object)user, (String)"user");
                return App.this.defaultArea.showUserInfo(user.getId());
            }
        };
        this.layout.setBasicLayout(new AreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.defaultArea, (Area)friendsArea, (Area)friendshipRequestsArea));
        friendsArea.setFriendshipRequestsArea(friendshipRequestsArea);
        friendshipRequestsArea.setFriendsArea(friendsArea);
        friendsArea.setDefaultArea((Area)this.defaultArea);
        friendshipRequestsArea.setDefaultArea((Area)this.defaultArea);
        return true;
    }

    private boolean onShowFollowings() {
        Runnable closing = () -> {
            this.layout.setBasicLayout(new AreaLayout((Area)this.defaultArea));
            this.luwrain.announceActiveArea();
        };
        FollowingsArea followingsArea = new FollowingsArea(this.luwrain, this.strings, this.base, this.actions, closing){

            @Override
            boolean onClick(UserFull user) {
                NullCheck.notNull((Object)user, (String)"user");
                return App.this.defaultArea.showUserInfo(user.getId());
            }
        };
        SuggestionsArea suggestionsArea = new SuggestionsArea(this.luwrain, this.strings, this.base, this.actions, closing){

            @Override
            boolean onProperties(UserFull user) {
                NullCheck.notNull((Object)user, (String)"user");
                return App.this.defaultArea.showUserInfo(user.getId());
            }
        };
        this.layout.setBasicLayout(new AreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.defaultArea, (Area)followingsArea, (Area)suggestionsArea));
        followingsArea.setSuggestionsArea(suggestionsArea);
        suggestionsArea.setFollowingsArea(followingsArea);
        followingsArea.setDefaultArea((Area)this.defaultArea);
        suggestionsArea.setDefaultArea((Area)this.defaultArea);
        return true;
    }

    private boolean onShowUsers() {
        Runnable closing = () -> {
            this.layout.setBasicLayout(new AreaLayout((Area)this.defaultArea));
            this.luwrain.announceActiveArea();
        };
        UsersArea usersArea = new UsersArea(this.luwrain, this.strings, this.base, this.actions, closing){

            @Override
            boolean onClick(UserFull user) {
                NullCheck.notNull((Object)user, (String)"user");
                return App.this.defaultArea.showUserInfo(user.getId());
            }

            @Override
            public boolean onInputEvent(InputEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.isSpecial() && !event.isModified()) {
                    switch (event.getSpecial()) {
                        case TAB: {
                            App.this.luwrain.setActiveArea((Area)App.this.defaultArea);
                            return true;
                        }
                    }
                }
                return super.onInputEvent(event);
            }
        };
        this.layout.setBasicLayout(new AreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.defaultArea, (Area)usersArea));
        this.luwrain.setActiveArea((Area)usersArea);
        return true;
    }

    public MonoApp.Result onMonoAppSecondInstance(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        return MonoApp.Result.BRING_FOREGROUND;
    }
}

