/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import com.vk.api.sdk.objects.users.UserFull;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import org.luwrain.app.vk.Actions;
import org.luwrain.app.vk.Base;
import org.luwrain.app.vk.FriendshipRequestsArea;
import org.luwrain.app.vk.Strings;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.BkgSounds;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Event;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.BackgroundSoundQuery;

abstract class FriendsArea
extends ListArea {
    private final Luwrain luwrain;
    private final Strings strings;
    private final Base base;
    private final Actions actions;
    private final Runnable closing;
    private Area defaultArea = null;
    private FriendshipRequestsArea friendshipRequestsArea = null;

    FriendsArea(Luwrain luwrain, Strings strings, Base base, Actions actions, Runnable closing) {
        super(FriendsArea.createParams(luwrain, strings, base));
        NullCheck.notNull((Object)actions, (String)"actions");
        NullCheck.notNull((Object)closing, (String)"closing");
        this.luwrain = luwrain;
        this.strings = strings;
        this.base = base;
        this.actions = actions;
        this.closing = closing;
        this.setListClickHandler((area, index, obj) -> {
            if (obj == null || !(obj instanceof UserFull)) {
                return false;
            }
            return this.onClick((UserFull)obj);
        });
        actions.onFriendshipRequestsUpdate(() -> {
            luwrain.setActiveArea((Area)this);
            this.refresh();
            this.friendshipRequestsArea.refresh();
        });
    }

    abstract boolean onClick(UserFull var1);

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case TAB: {
                    if (this.friendshipRequestsArea == null) {
                        return false;
                    }
                    this.luwrain.setActiveArea((Area)this.friendshipRequestsArea);
                    return true;
                }
                case BACKSPACE: {
                    if (this.defaultArea == null) {
                        return false;
                    }
                    this.luwrain.setActiveArea(this.defaultArea);
                    return true;
                }
                case ESCAPE: {
                    this.closing.run();
                    return true;
                }
            }
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case ACTION: {
                if (ActionEvent.isAction((Event)event, (String)"message")) {
                    return this.onMessage();
                }
                if (ActionEvent.isAction((Event)event, (String)"delete")) {
                    return this.onDelete();
                }
                return false;
            }
            case CLOSE: {
                this.base.closeApp();
                return true;
            }
        }
        return super.onSystemEvent(event);
    }

    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 7: {
                if (this.base.isBusy()) {
                    ((BackgroundSoundQuery)query).answer(new BackgroundSoundQuery.Answer(BkgSounds.FETCHING));
                    return true;
                }
                return false;
            }
        }
        return super.onAreaQuery(query);
    }

    public Action[] getAreaActions() {
        return this.actions.lists.getFriendsActions();
    }

    private boolean onMessage() {
        Object selected = this.selected();
        if (selected == null || !(selected instanceof UserFull)) {
            return false;
        }
        UserFull user = (UserFull)selected;
        String text = this.actions.conv.messageText();
        if (text == null || text.trim().isEmpty()) {
            return true;
        }
        return this.actions.onMessageSend(user.getId(), text, () -> this.luwrain.message(this.strings.messageSent(), Luwrain.MessageType.OK));
    }

    private boolean onDelete() {
        Object selected = this.selected();
        if (selected == null || !(selected instanceof UserFull)) {
            return false;
        }
        UserFull user = (UserFull)selected;
        return this.actions.onFriendshipDelete(user.getId(), () -> {
            this.refresh();
            this.luwrain.playSound(Sounds.OK);
        });
    }

    void setDefaultArea(Area defaultArea) {
        NullCheck.notNull((Object)defaultArea, (String)"defaultArea");
        if (this.defaultArea != null) {
            throw new RuntimeException("defaultArea already set");
        }
        this.defaultArea = defaultArea;
    }

    void setFriendshipRequestsArea(FriendshipRequestsArea friendshipRequestsArea) {
        NullCheck.notNull((Object)((Object)friendshipRequestsArea), (String)"friendshipRequestsArea");
        if (this.friendshipRequestsArea != null) {
            throw new RuntimeException("friendshipRequestsArea already set");
        }
        this.friendshipRequestsArea = friendshipRequestsArea;
    }

    private static ListArea.Params createParams(Luwrain luwrain, Strings strings, Base base) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)strings, (String)"strings");
        NullCheck.notNull((Object)base, (String)"base");
        ListArea.Params params = new ListArea.Params();
        params.context = new DefaultControlContext(luwrain);
        params.model = new Model(base);
        params.appearance = new Appearance(luwrain, strings, base);
        params.name = strings.friendsAreaName();
        return params;
    }

    private static final class Model
    implements ListArea.Model {
        private final Base base;

        Model(Base base) {
            NullCheck.notNull((Object)base, (String)"base");
            this.base = base;
        }

        public int getItemCount() {
            NullCheck.notNullItems((Object[])this.base.friends, (String)"base.friends");
            return this.base.friends.length;
        }

        public Object getItem(int index) {
            NullCheck.notNullItems((Object[])this.base.friends, (String)"base.friends");
            return this.base.friends[index];
        }

        public void refresh() {
        }
    }

    private static final class Appearance
    implements ListArea.Appearance<Object> {
        private final Luwrain luwrain;
        private final Strings strings;
        private final Base base;

        Appearance(Luwrain luwrain, Strings strings, Base base) {
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            NullCheck.notNull((Object)strings, (String)"strings");
            NullCheck.notNull((Object)base, (String)"base");
            this.luwrain = luwrain;
            this.strings = strings;
            this.base = base;
        }

        public void announceItem(Object item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            if (item instanceof UserFull) {
                UserFull user = (UserFull)item;
                Object extInfo = "";
                if (user.getStatus() != null && !user.getStatus().trim().isEmpty()) {
                    extInfo = (String)extInfo + ", " + user.getStatus().trim();
                }
                if (user.getLastSeen() != null) {
                    Date date = new Date(user.getLastSeen().getTime().longValue() * 1000L);
                    extInfo = (String)extInfo + ", " + this.strings.lastSeen(this.luwrain.i18n().getPastTimeBrief(date));
                }
                this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)(user.getFirstName() + " " + user.getLastName() + (String)extInfo), null));
                return;
            }
            this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)item.toString(), null));
        }

        public String getScreenAppearance(Object item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            if (item instanceof UserFull) {
                UserFull user = (UserFull)item;
                Object status = user.getStatus() != null && !user.getStatus().trim().isEmpty() ? " (" + user.getStatus().trim() + ")" : "";
                return user.getFirstName() + " " + user.getLastName() + (String)status;
            }
            return item.toString();
        }

        public int getObservableLeftBound(Object item) {
            return 0;
        }

        public int getObservableRightBound(Object item) {
            return this.getScreenAppearance(item, EnumSet.noneOf(ListArea.Appearance.Flags.class)).length();
        }
    }
}

