/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import com.vk.api.sdk.objects.users.UserFull;
import com.vk.api.sdk.objects.wall.WallpostFull;
import java.util.ArrayList;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.vk2.App;
import org.luwrain.app.vk2.UserAppearance;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.NavigationArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.events.InputEvent;

final class WallPostLayout
extends LayoutBase {
    private static final int MAX_LINE_LEN = 80;
    private final App app;
    private final WallpostFull wallPost;
    final NavigationArea textArea;
    final ListArea<UserFull> likesArea;
    private final List<Line> lines = new ArrayList<Line>();

    WallPostLayout(App app, WallpostFull wallPost, List<UserFull> likes, LayoutBase.ActionHandler closing) {
        super((AppBase)app);
        this.app = app;
        this.wallPost = wallPost;
        this.prepareText();
        this.textArea = new NavigationArea(this.getControlContext()){

            public int getLineCount() {
                return WallPostLayout.this.lines.size();
            }

            public String getLine(int index) {
                return WallPostLayout.this.lines.get((int)index).text;
            }

            public String getAreaName() {
                return "\u0417\u0430\u043f\u0438\u0441\u044c";
            }
        };
        this.likesArea = new ListArea(this.listParams(params -> {
            params.name = "\u041b\u0430\u0439\u043a\u0438";
            params.model = new ListUtils.ListModel(likes);
            params.appearance = new UserAppearance(app);
        }));
        this.setCloseHandler(closing);
        this.setAreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.textArea, null, (Area)this.likesArea, this.actions(new LayoutBase.ActionInfo[]{this.action("new-friendship", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u0434\u0440\u0443\u0437\u044c\u044f", new InputEvent(InputEvent.Special.INSERT), () -> app.newFriendship((UserFull)this.likesArea.selected()))}));
    }

    void prepareText() {
        this.lines.add(new Line(""));
        if (this.wallPost.getViews() != null) {
            this.lines.add(new Line("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u043e\u0432: " + this.wallPost.getViews().getCount()));
            this.lines.add(new Line(""));
        }
        if (this.wallPost.getAttachments() != null && !this.wallPost.getAttachments().isEmpty()) {
            this.lines.add(new Line("\u041f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u0438\u0439: " + this.wallPost.getAttachments().size()));
            this.lines.add(new Line(""));
        }
        for (String s : this.wallPost.getText().split("\n", -1)) {
            if (s.trim().isEmpty()) continue;
            StringBuilder line = new StringBuilder();
            for (String w : s.split(" ", -1)) {
                if (w.isEmpty()) continue;
                if (line.length() == 0) {
                    line.append(w);
                    continue;
                }
                if (line.length() + w.length() + 1 <= 80) {
                    line.append(" ").append(w);
                    continue;
                }
                this.lines.add(new Line(new String(line)));
                line = new StringBuilder();
                line.append(w);
            }
            if (line.length() > 0) {
                this.lines.add(new Line(new String(line)));
            }
            this.lines.add(new Line(""));
        }
    }

    static final class Line {
        final String text;

        Line(String text) {
            this.text = text;
        }
    }
}

