/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk2;

import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.httpclient.HttpTransportClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.luwrain.app.vk2.Settings;
import org.luwrain.app.vk2.Watch;
import org.luwrain.app.vk2.WatchingListener;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

public final class Watching {
    private static final String LOG_COMPONENT = "vk";
    final Luwrain luwrain;
    final List<Watch> watches = new ArrayList<Watch>();

    public Watching(Luwrain luwrain) {
        this.luwrain = luwrain;
        this.loadWatches();
        this.run();
    }

    void run() {
        for (Watch w : this.watches) {
            this.luwrain.executeBkg(new FutureTask<Object>(w, null));
        }
    }

    void loadWatches() {
        Settings sett = Settings.create(this.luwrain);
        if (sett.getUserId(0) == 0 || sett.getAccessToken("").isEmpty()) {
            return;
        }
        VkApiClient vk = new VkApiClient((TransportClient)new HttpTransportClient());
        UserActor actor = new UserActor(Integer.valueOf(sett.getUserId(0)), sett.getAccessToken(""));
        this.watches.add(new Watch(this.luwrain, sett.getUserId(0), vk, actor));
    }

    void addListener(int userId, WatchingListener listener) {
        NullCheck.notNull((Object)listener, (String)"listener");
        for (Watch w : this.watches) {
            if (w.userId != userId) continue;
            w.listeners.add(listener);
            return;
        }
    }

    void removeListener(WatchingListener listener) {
        NullCheck.notNull((Object)listener, (String)"listener");
        block0: for (Watch w : this.watches) {
            Iterator<WatchingListener> it = w.listeners.iterator();
            while (it.hasNext()) {
                if (it.next() != listener) continue;
                it.remove();
                continue block0;
            }
        }
    }
}

