/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import java.util.Objects;

public final class Album
implements Comparable {
    private Type type;
    private String title;
    private String url;
    private String path;
    private Integer volume = null;
    private boolean savePos;
    private int trackNum;
    private long posMsec;

    public Album(Type type, String title, String path, String url) {
        this.type = Objects.requireNonNull(type, "type");
        this.title = Objects.requireNonNull(title, "title can't be null");
        this.path = path;
        this.url = url;
    }

    public int getVolume() {
        if (this.volume == null) {
            return 100;
        }
        return Math.min(Math.max(this.volume, 0), 100);
    }

    public boolean isSection() {
        return this.type == Type.SECTION;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Album)) {
            return 0;
        }
        return this.getTitle().compareTo(((Album)o).getTitle());
    }

    public String toString() {
        return this.getTitle();
    }

    public Type getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSavePos() {
        return this.savePos;
    }

    public int getTrackNum() {
        return this.trackNum;
    }

    public long getPosMsec() {
        return this.posMsec;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVolume(Integer volume) {
        this.volume = volume;
    }

    public void setSavePos(boolean savePos) {
        this.savePos = savePos;
    }

    public void setTrackNum(int trackNum) {
        this.trackNum = trackNum;
    }

    public void setPosMsec(long posMsec) {
        this.posMsec = posMsec;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Album)) {
            return false;
        }
        Album other = (Album)o;
        if (this.isSavePos() != other.isSavePos()) {
            return false;
        }
        if (this.getTrackNum() != other.getTrackNum()) {
            return false;
        }
        if (this.getPosMsec() != other.getPosMsec()) {
            return false;
        }
        if (this.getVolume() != other.getVolume()) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSavePos() ? 79 : 97);
        result = result * 59 + this.getTrackNum();
        long $posMsec = this.getPosMsec();
        result = result * 59 + (int)($posMsec >>> 32 ^ $posMsec);
        result = result * 59 + this.getVolume();
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public Album() {
    }

    public static enum Type {
        SECTION,
        STREAMING,
        DIR,
        M3U,
        UNKNOWN;

    }
}

