/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.player.Albums;
import org.luwrain.app.player.Config;
import org.luwrain.app.player.ControlArea;
import org.luwrain.app.player.Conv;
import org.luwrain.app.player.Hooks;
import org.luwrain.app.player.MainLayout;
import org.luwrain.app.player.Starting;
import org.luwrain.app.player.Strings;
import org.luwrain.app.player.TrackInfo;
import org.luwrain.app.player.Utils;
import org.luwrain.controls.ListArea;
import org.luwrain.core.Application;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.MonoApp;
import org.luwrain.player.Listener;
import org.luwrain.player.Player;
import org.luwrain.player.Playlist;

public final class App
extends AppBase<Strings>
implements Application,
MonoApp,
Listener {
    private static final Logger log = LogManager.getLogger();
    private final String[] args;
    final Starting starting = new Starting(this);
    Config conf = null;
    private Player player = null;
    private Conv conv = null;
    private MainLayout mainLayout = null;
    Albums albums = null;
    private Hooks hooks = null;
    final ConcurrentMap<String, TrackInfo> trackInfoMap = new ConcurrentHashMap<String, TrackInfo>();

    App() {
        this(null);
    }

    App(String[] args) {
        super(Strings.class, "luwrain.player");
        this.args = args != null ? (String[])args.clone() : new String[]{};
    }

    public AreaLayout onAppInit() throws Exception {
        this.conv = new Conv(this);
        this.conf = (Config)this.getLuwrain().loadConf(Config.class);
        if (this.conf == null) {
            this.conf = new Config();
        }
        this.albums = new Albums(this);
        this.player = this.getLuwrain().getPlayer();
        if (this.player == null) {
            throw new Exception("No system player");
        }
        this.player.addListener((Listener)this);
        this.hooks = new Hooks(this.getLuwrain());
        this.mainLayout = new MainLayout(this, this.player);
        this.setAppName(((Strings)this.getStrings()).appName());
        return this.mainLayout.getAreaLayout();
    }

    void fillTrackInfoMap(Playlist playlist, ListArea listArea) {
        ArrayList<String> tracks = new ArrayList<String>();
        int count = playlist.getTrackCount();
        for (int i = 0; i < count; ++i) {
            tracks.add(playlist.getTrackUrl(i));
        }
        this.getLuwrain().executeBkg(() -> {
            for (String s : tracks) {
                try {
                    this.trackInfoMap.put(s, new TrackInfo(new URL(s)));
                    this.getLuwrain().runUiSafely(() -> listArea.refresh());
                }
                catch (Throwable e) {
                    log.debug("Unable to read tags of the file: " + e.getClass().getName() + ": " + e.getMessage());
                }
            }
        });
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public void closeApp() {
        this.player.removeListener((Listener)this);
        super.closeApp();
    }

    public MonoApp.Result onMonoAppSecondInstance(Application app) {
        return MonoApp.Result.BRING_FOREGROUND;
    }

    public void onNewPlaylist(Playlist playlist) {
        this.getLuwrain().runUiSafely(() -> {
            if (this.mainLayout != null) {
                this.mainLayout.onNewPlaylist(playlist);
            }
        });
    }

    public void onNewTrack(Playlist playlist, int trackNum) {
        this.getLuwrain().runUiSafely(() -> {
            if (this.mainLayout == null) {
                return;
            }
            TrackInfo trackInfo = (TrackInfo)this.trackInfoMap.get(playlist.getTrackUrl(trackNum));
            if (trackInfo != null) {
                this.mainLayout.controlArea.setPlaylistTitle(trackInfo.artist);
                this.mainLayout.controlArea.setTrackTitle(trackInfo.title);
            } else {
                this.mainLayout.controlArea.setPlaylistTitle("-");
                this.mainLayout.controlArea.setTrackTitle("-");
            }
            this.mainLayout.controlArea.setTrackTime(0L);
        });
    }

    public void onTrackTime(Playlist playlist, int trackNum, long msec) {
        this.getLuwrain().runUiSafely(() -> {
            if (this.mainLayout != null) {
                this.mainLayout.controlArea.setTrackTime(msec);
            }
        });
    }

    public void onNewState(Playlist playlist, Player.State state) {
        this.getLuwrain().runUiSafely(() -> {
            if (this.mainLayout != null) {
                switch (state) {
                    case STOPPED: {
                        this.mainLayout.controlArea.setMode(ControlArea.Mode.STOPPED);
                        break;
                    }
                    case PAUSED: {
                        if (Utils.isStreamingPlaylist(playlist)) {
                            this.mainLayout.controlArea.setMode(ControlArea.Mode.PLAYING_STREAMING);
                            break;
                        }
                        this.mainLayout.controlArea.setMode(ControlArea.Mode.PAUSED);
                        break;
                    }
                    case PLAYING: {
                        if (Utils.isStreamingPlaylist(playlist)) {
                            this.mainLayout.controlArea.setMode(ControlArea.Mode.PLAYING_STREAMING);
                            break;
                        }
                        this.mainLayout.controlArea.setMode(ControlArea.Mode.PLAYING);
                    }
                }
            }
        });
    }

    public void onPlayingError(Playlist playlist, Exception e) {
        this.crash(e);
    }

    Player getPlayer() {
        return this.player;
    }

    Hooks getHooks() {
        return this.hooks;
    }

    public Conv getConv() {
        return this.conv;
    }
}

