/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.luwrain.antlr.inlandes.InlandesBaseListener;
import org.luwrain.antlr.inlandes.InlandesLexer;
import org.luwrain.antlr.inlandes.InlandesParser;
import org.luwrain.inlandes.Lang;
import org.luwrain.inlandes.Ref;
import org.luwrain.inlandes.ReplacementToken;
import org.luwrain.inlandes.RuleStatement;
import org.luwrain.inlandes.ScriptEngine;
import org.luwrain.inlandes.WhereStatement;
import org.luwrain.inlandes.operations.Action;
import org.luwrain.inlandes.operations.Assignment;

public class SyntaxParser {
    private static final String OPTIONAL_MARK = "?";
    private final ScriptEngine scriptEngine;
    private final Lang lang;
    private final Map<String, Set<String>> dicts;

    public SyntaxParser(ScriptEngine scriptEngine, Lang lang, Map<String, Set<String>> dicts) {
        this.scriptEngine = scriptEngine;
        this.lang = lang;
        this.dicts = dicts;
    }

    public SyntaxParser() {
        this(null, null, new HashMap<String, Set<String>>());
    }

    private WhereStatement.Item createWhereItem(InlandesParser.WhereItemContext c) {
        if (c.whereBlock() != null) {
            InlandesParser.WhereBlockContext block = c.whereBlock();
            ArrayList<WhereStatement.Item> items = new ArrayList<WhereStatement.Item>();
            for (InlandesParser.WhereItemContext i : block.whereItem()) {
                items.add(this.createWhereItem(i));
            }
            return new WhereStatement.Block(items, c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
        }
        if (c.whereAlternative() != null) {
            InlandesParser.WhereAlternativeContext alt = c.whereAlternative();
            ArrayList<WhereStatement.Item> items = new ArrayList<WhereStatement.Item>();
            for (InlandesParser.WhereItemContext i : alt.whereItem()) {
                items.add(this.createWhereItem(i));
            }
            return new WhereStatement.Alternative(items, c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
        }
        if (c.whereFixed() != null) {
            InlandesParser.WhereFixedContext fixed = c.whereFixed();
            if (fixed.Space() != null) {
                return new WhereStatement.Fixed(token -> token.isSpace(), " ", c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
            }
            if (fixed.CyrilPlain() != null) {
                String textUpper = fixed.CyrilPlain().toString().toUpperCase();
                return new WhereStatement.Fixed(token -> token.isCyril() && token.getText().length() == textUpper.length() && token.getText().toUpperCase().equals(textUpper), textUpper, c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
            }
            if (fixed.Latin() != null) {
                String text = fixed.Latin().toString();
                String textUpper = text.substring(1, text.length() - 1).toUpperCase();
                return new WhereStatement.Fixed(token -> token.isLatin() && token.getText().toUpperCase().equals(textUpper), textUpper, c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
            }
            if (fixed.Punc() != null) {
                String t = fixed.Punc().toString();
                String text = t.substring(1, t.length() - 1);
                return new WhereStatement.Fixed(token -> token.isPunc() && token.getText().toUpperCase().equals(text), text, c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
            }
            if (fixed.Dict() != null) {
                Set<String> dict = this.dicts.get(fixed.Dict().toString().substring(1));
                if (dict == null) {
                    throw new RuntimeException("No such dict: " + fixed.Dict().toString());
                }
                return new WhereStatement.Fixed(token -> dict.contains(token.getText()), fixed.Dict().toString(), c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
            }
            if (fixed.LemmaCyril() != null) {
                if (this.lang == null) {
                    throw new IllegalStateException("No lang, you can't use lemmas in your rules");
                }
                String l = fixed.LemmaCyril().toString();
                String lemma = l.substring(1, l.length() - 1);
                return new WhereStatement.Fixed(token -> token.isCyril() && this.lang.isWordWithLemma(token, lemma), fixed.LemmaCyril().toString(), c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
            }
            if (fixed.LemmaLatin() != null) {
                if (this.lang == null) {
                    throw new IllegalStateException("No lang, you can't use lemmas in your rules");
                }
                String l = fixed.LemmaLatin().toString();
                String lemma = l.substring(1, l.length() - 1);
                return new WhereStatement.Fixed(token -> token.isLatin() && this.lang.isWordWithLemma(token, lemma), fixed.LemmaLatin().toString(), c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
            }
            if (fixed.JsObj() != null) {
                if (this.scriptEngine == null) {
                    throw new IllegalStateException("No script engine, you can't use JavaScript references in your rules");
                }
                return new WhereStatement.Fixed(token -> this.scriptEngine.isObjWithTrueValue(token, fixed.JsObj().toString().substring(1)), fixed.JsObj().toString(), c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
            }
            if (fixed.Cl() != null) {
                return this.createClassFilter(fixed.Cl().toString().substring(1), c.Ref() != null ? new Ref(Integer.parseInt(c.Ref().toString().substring(1))) : null, c.Optional() != null && c.Optional().toString().equals(OPTIONAL_MARK));
            }
        }
        throw new RuntimeException(c.toString());
    }

    private WhereStatement.Fixed createClassFilter(String className, Ref ref, boolean optional) {
        switch (className) {
            case "any": {
                return new WhereStatement.Fixed(token -> !(token instanceof ReplacementToken), "/" + className, ref, optional);
            }
            case "char": {
                return new WhereStatement.Fixed(token -> token.getText().length() == 1, "\\" + className, ref, optional);
            }
            case "char-cyril-lower": {
                return new WhereStatement.Fixed(token -> token.isCyril() && token.getText().length() == 1 && Character.isLowerCase(token.getText().charAt(0)), "\\" + className, ref, optional);
            }
            case "char-cyril-upper": {
                return new WhereStatement.Fixed(token -> token.isCyril() && token.getText().length() == 1 && Character.isUpperCase(token.getText().charAt(0)), "\\" + className, ref, optional);
            }
            case "char-latin-lower": {
                return new WhereStatement.Fixed(token -> token.isLatin() && token.getText().length() == 1 && Character.isLowerCase(token.getText().charAt(0)), "\\" + className, ref, optional);
            }
            case "char-latin-upper": {
                return new WhereStatement.Fixed(token -> token.isLatin() && token.getText().length() == 1 && Character.isUpperCase(token.getText().charAt(0)), "\\" + className, ref, optional);
            }
            case "char-lower": {
                return new WhereStatement.Fixed(token -> token.getText().length() == 1 && Character.isLowerCase(token.getText().charAt(0)), "\\" + className, ref, optional);
            }
            case "char-upper": {
                return new WhereStatement.Fixed(token -> token.getText().length() == 1 && Character.isUpperCase(token.getText().charAt(0)), "\\" + className, ref, optional);
            }
            case "cyril": {
                return new WhereStatement.Fixed(token -> token.isCyril(), "\\" + className, ref, optional);
            }
            case "cyril-cap": {
                return new WhereStatement.Fixed(token -> token.isCyril() && !token.getText().isEmpty() && Character.isUpperCase(token.getText().charAt(0)), "\\" + className, ref, optional);
            }
            case "cyril-lower": {
                return new WhereStatement.Fixed(token -> token.isCyril() && token.getText().toLowerCase().equals(token.getText()), "\\" + className, ref, optional);
            }
            case "cyril-upper": {
                return new WhereStatement.Fixed(token -> token.isCyril() && token.getText().toUpperCase().equals(token.getText()), "\\" + className, ref, optional);
            }
            case "latin": {
                return new WhereStatement.Fixed(token -> token.isLatin(), "\\" + className, ref, optional);
            }
            case "latin-cap": {
                return new WhereStatement.Fixed(token -> token.isLatin() && !token.getText().isEmpty() && Character.isUpperCase(token.getText().charAt(0)), "\\" + className, ref, optional);
            }
            case "latin-lower": {
                return new WhereStatement.Fixed(token -> token.isLatin() && token.getText().toLowerCase().equals(token.getText()), "\\" + className, ref, optional);
            }
            case "latin-upper": {
                return new WhereStatement.Fixed(token -> token.isLatin() && token.getText().toUpperCase().equals(token.getText()), "\\" + className, ref, optional);
            }
            case "num": {
                return new WhereStatement.Fixed(token -> token.isNum(), "\\" + className, ref, optional);
            }
        }
        throw new RuntimeException("Unknown token class: " + className);
    }

    public RuleStatement[] parse(String text) {
        BaseErrorListener errors = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new RuntimeException(msg);
            }
        };
        InlandesLexer l = new InlandesLexer((CharStream)CharStreams.fromString((String)text));
        l.removeErrorListeners();
        l.addErrorListener((ANTLRErrorListener)errors);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)l);
        InlandesParser p = new InlandesParser((TokenStream)tokens);
        InlandesParser.NotationContext tree = p.notation();
        ParseTreeWalker walker = new ParseTreeWalker();
        Listener listener = new Listener();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        return listener.rules.toArray(new RuleStatement[listener.rules.size()]);
    }

    private final class Listener
    extends InlandesBaseListener {
        List<RuleStatement> rules = new ArrayList<RuleStatement>();
        private RuleStatement rule = null;

        private Listener() {
        }

        @Override
        public void visitErrorNode(ErrorNode node) {
            throw new RuntimeException(node.toString());
        }

        @Override
        public void enterRuleStatement(InlandesParser.RuleStatementContext ctx) {
            this.rule = new RuleStatement();
        }

        @Override
        public void exitRuleStatement(InlandesParser.RuleStatementContext ctx) {
            if (this.rule == null) {
                throw new NullPointerException("rule can't be null");
            }
            this.rules.add(this.rule);
            this.rule = null;
        }

        @Override
        public void exitWhereStatement(InlandesParser.WhereStatementContext c) {
            ArrayList<WhereStatement.Item> res = new ArrayList<WhereStatement.Item>();
            for (InlandesParser.WhereItemContext i : c.whereItem()) {
                res.add(SyntaxParser.this.createWhereItem(i));
            }
            this.rule.setWhere(new WhereStatement(res));
        }

        @Override
        public void exitStageStatement(InlandesParser.StageStatementContext c) {
            this.rule.setStageNum(Integer.parseInt(c.Num().toString().trim()));
        }

        @Override
        public void exitAction(InlandesParser.ActionContext c) {
            String js = c.Js().toString();
            this.rule.addOperation(new Action(js.substring(2, js.length() - 2)));
        }

        @Override
        public void exitAssignment(InlandesParser.AssignmentContext c) {
            if (c.Js() != null) {
                String js = c.Js().toString();
                this.rule.addOperation(new Assignment(new Ref(Integer.parseInt(c.Ref().toString().substring(1))), Assignment.ValueType.JS, js.substring(2, js.length() - 2)));
            }
            if (c.Str() != null) {
                String str = c.Str().toString();
                this.rule.addOperation(new Assignment(new Ref(Integer.parseInt(c.Ref().toString().substring(1))), Assignment.ValueType.STRING, str.substring(1, str.length() - 1)));
            }
        }
    }
}

