/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes.cli;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.luwrain.inlandes.Inlandes;
import org.luwrain.inlandes.Token;

public final class Main {
    public static void main(String[] args) throws IOException {
        Inlandes inlandes = new Inlandes();
        inlandes.loadStandardLibrary();
        Main.parseArgs(inlandes, args);
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        String line = r.readLine();
        while (line != null) {
            System.out.println(Token.concatText(inlandes.process(line)));
            line = r.readLine();
        }
    }

    private static void parseArgs(Inlandes inlandes, String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.equals("--help") || a.equals("-h")) {
                Main.printHelp();
            }
            if (a.equals("-i") || a.equals("--input")) {
                if (++i >= args.length) {
                    Main.errorMsg("--input(-i) requires an argument");
                }
                System.setIn(new FileInputStream(args[i]));
                continue;
            }
            if (!a.endsWith(".rules")) continue;
            inlandes.loadRulesFromFile(a);
        }
    }

    private static void printHelp() {
        System.out.println("Inlandes: a text processing language" + System.lineSeparator() + "Michael Pozhidaev <msp@luwrain.org>" + System.lineSeparator() + "" + System.lineSeparator() + "Usage: inlandes [OPTIONS] [file1.(rules|js) [file2.(rules|js)]]" + System.lineSeparator() + "" + System.lineSeparator() + "Options:" + System.lineSeparator() + "--help, -h: print this help and exit" + System.lineSeparator() + "--input FILE, -i FILE: read the input from FILE (stdin by default)" + System.lineSeparator());
        System.exit(0);
    }

    private static void errorMsg(String text) {
        System.err.println("inlandes: " + text);
        System.exit(1);
    }
}

