/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes.util;

public final class Token
implements org.luwrain.inlandes.Token {
    public final Type type;
    public final String text;

    public Token(Type type, String text) {
        if (type == null) {
            throw new NullPointerException("type may not be null");
        }
        if (text == null) {
            throw new NullPointerException("text may not be null");
        }
        if (text.isEmpty()) {
            throw new IllegalArgumentException("text may not be empty");
        }
        this.type = type;
        this.text = text;
    }

    @Override
    public boolean isLatin() {
        return this.type == Type.LATIN;
    }

    @Override
    public boolean isCyril() {
        return this.type == Type.CYRIL;
    }

    @Override
    public boolean isNum() {
        return this.type == Type.NUM;
    }

    @Override
    public boolean isSpace() {
        return this.type == Type.SPACE;
    }

    @Override
    public boolean isPunc() {
        return this.type == Type.PUNC;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Token)) {
            return false;
        }
        Token t = (Token)o;
        return this.type == t.type && this.text.equals(t.text);
    }

    public boolean isFirstUpperCase() {
        if (this.type != Type.LATIN && this.type != Type.CYRIL) {
            return false;
        }
        return Character.isUpperCase(this.text.charAt(0));
    }

    public boolean isLastUpperCase() {
        if (this.type != Type.LATIN && this.type != Type.CYRIL) {
            return false;
        }
        return Character.isUpperCase(this.text.charAt(this.text.length() - 1));
    }

    public static String text(Token[] tokens) {
        if (tokens == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (Token t : tokens) {
            if (t == null) continue;
            b.append(t.text);
        }
        return new String(b);
    }

    public static int find(Token[] tokens, Token token) {
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].equals(token)) continue;
            return i;
        }
        return -1;
    }

    public static Token num(String text) {
        return new Token(Type.NUM, text);
    }

    public static Token punc(String text) {
        return new Token(Type.PUNC, text);
    }

    public static Token latin(String text) {
        return new Token(Type.LATIN, text);
    }

    public static Token cyril(String text) {
        return new Token(Type.CYRIL, text);
    }

    public static enum Type {
        NUM,
        LATIN,
        CYRIL,
        SPACE,
        PUNC;

    }
}

