/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.events.longpoll;

import com.google.gson.JsonElement;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.events.EventsHandler;
import com.vk.api.sdk.exceptions.ApiException;
import com.vk.api.sdk.exceptions.ClientException;
import com.vk.api.sdk.objects.callback.longpoll.responses.GetLongPollEventsResponse;
import com.vk.api.sdk.objects.callback.messages.CallbackMessage;
import com.vk.api.sdk.objects.groups.LongPollServer;
import com.vk.api.sdk.objects.groups.responses.GetLongPollServerResponse;
import java.util.concurrent.Executors;
import org.apache.http.ConnectionClosedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LongPollApi
extends EventsHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LongPollApi.class);
    private final VkApiClient client;
    private final int waitTime;
    private volatile boolean isRunning = false;

    protected LongPollApi(VkApiClient client, int waitTime) {
        this.client = client;
        this.waitTime = waitTime;
    }

    private LongPollServer initServer(GetLongPollServerResponse lpServerResponse) {
        return new LongPollServer().setKey(lpServerResponse.getKey()).setTs(lpServerResponse.getTs()).setServer(lpServerResponse.getServer());
    }

    private LongPollServer getLongPollServer(UserActor actor, int groupId) {
        try {
            return this.initServer((GetLongPollServerResponse)this.client.groupsLongPoll().getLongPollServer(actor, groupId).execute());
        }
        catch (ApiException | ClientException e) {
            return null;
        }
    }

    private LongPollServer getLongPollServer(GroupActor actor) {
        try {
            return this.initServer((GetLongPollServerResponse)this.client.groupsLongPoll().getLongPollServer(actor, (int)actor.getGroupId()).execute());
        }
        catch (ApiException | ClientException e) {
            return null;
        }
    }

    private void handleUpdates(LongPollServer lpServer) throws ConnectionClosedException {
        if (lpServer == null) {
            LOG.error("Getting LongPoll server was failed");
        }
        this.isRunning = true;
        try {
            LOG.info("LongPoll handler started to handle events");
            String timestamp = lpServer.getTs();
            while (this.isRunning) {
                GetLongPollEventsResponse eventsResponse = (GetLongPollEventsResponse)this.client.longPoll().getEvents(lpServer.getServer(), lpServer.getKey(), timestamp).waitTime(this.waitTime).execute();
                eventsResponse.getUpdates().forEach(e -> this.parse((CallbackMessage)this.gson.fromJson((JsonElement)e, CallbackMessage.class)));
                timestamp = eventsResponse.getTs();
            }
            LOG.info("LongPoll handler stopped to handle events");
        }
        catch (ApiException | ClientException e2) {
            LOG.error("Getting LongPoll events was failed", (Throwable)e2);
            throw new ConnectionClosedException();
        }
        this.isRunning = false;
    }

    protected void run(GroupActor actor) {
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                LongPollServer lpServer = this.getLongPollServer(actor);
                this.handleUpdates(lpServer);
            }
            catch (ConnectionClosedException e) {
                this.run(actor);
            }
        });
    }

    protected void run(UserActor actor, int groupId) {
        Executors.newSingleThreadExecutor().execute(() -> {
            try {
                LongPollServer lpServer = this.getLongPollServer(actor, groupId);
                this.handleUpdates(lpServer);
            }
            catch (ConnectionClosedException e) {
                this.run(actor, groupId);
            }
        });
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

