/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.plmp3;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDeviceBase;
import org.luwrain.core.Log;
import org.luwrain.util.SoundUtils;

class CustomDevice
extends AudioDeviceBase
implements AutoCloseable {
    private static final String LOG_COMPONENT = "plmp3";
    SourceDataLine source = null;
    private final int initialVolume;
    private AudioFormat fmt = null;
    private byte[] byteBuf = new byte[4096];

    CustomDevice(int initialVolume) {
        if (initialVolume < 0 || initialVolume > 100) {
            throw new IllegalArgumentException("initialVolume (" + initialVolume + ") must be between 0 and 100 (inclusively)");
        }
        this.initialVolume = initialVolume;
    }

    void setVolume(int value) {
        if (this.source == null) {
            return;
        }
        if (!SoundUtils.setLineMasterGanePercent((SourceDataLine)this.source, (int)value)) {
            Log.error((String)LOG_COMPONENT, (String)("unable to set volume (" + value + ")"));
        }
    }

    protected void openImpl() throws JavaLayerException {
    }

    protected void closeImpl() {
        if (this.source != null) {
            this.source.close();
        }
    }

    protected void writeImpl(short[] samples, int offs, int len) throws JavaLayerException {
        if (this.source == null) {
            this.createSource();
        }
        byte[] b = this.toByteArray(samples, offs, len);
        this.source.write(b, 0, len * 2);
    }

    protected void flushImpl() {
        if (this.source != null) {
            this.source.drain();
        }
    }

    public int getPosition() {
        int pos = 0;
        if (this.source != null) {
            pos = (int)(this.source.getMicrosecondPosition() / 1000L);
        }
        return pos;
    }

    private AudioFormat getAudioFormat() {
        if (this.fmt == null) {
            Decoder decoder = this.getDecoder();
            this.fmt = new AudioFormat(decoder.getOutputFrequency(), 16, decoder.getOutputChannels(), true, false);
        }
        return this.fmt;
    }

    private DataLine.Info getSourceLineInfo() {
        AudioFormat fmt = this.getAudioFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, fmt);
        return info;
    }

    private void createSource() throws JavaLayerException {
        Throwable t = null;
        try {
            Line line = this.createLine();
            if (line instanceof SourceDataLine) {
                this.source = (SourceDataLine)line;
                this.source.open(this.fmt);
                if (!SoundUtils.setLineMasterGanePercent((SourceDataLine)this.source, (int)this.initialVolume)) {
                    Log.error((String)LOG_COMPONENT, (String)("unable to set initial volume (" + this.initialVolume + ")"));
                }
                this.source.start();
            }
        }
        catch (RuntimeException ex) {
            t = ex;
        }
        catch (LinkageError ex) {
            t = ex;
        }
        catch (LineUnavailableException ex) {
            t = ex;
        }
        if (this.source == null) {
            throw new JavaLayerException("cannot obtain source audio line", t);
        }
    }

    private Line createLine() throws LineUnavailableException {
        Line line = AudioSystem.getLine(this.getSourceLineInfo());
        return line;
    }

    private byte[] getByteArray(int length) {
        if (this.byteBuf.length < length) {
            this.byteBuf = new byte[length + 1024];
        }
        return this.byteBuf;
    }

    private byte[] toByteArray(short[] samples, int offs, int len) {
        byte[] b = this.getByteArray(len * 2);
        int idx = 0;
        while (len-- > 0) {
            short s = samples[offs++];
            b[idx++] = (byte)s;
            b[idx++] = (byte)(s >>> 8);
        }
        return b;
    }
}

