/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.plmp3;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MediaResourcePlayer;
import org.luwrain.core.NullCheck;
import org.luwrain.extensions.plmp3.CustomDevice;

final class Instance
implements MediaResourcePlayer.Instance {
    static final String LOG_COMPONENT = "plmp3";
    private final Luwrain luwrain;
    private final MediaResourcePlayer.Listener listener;
    private Runnable task = null;
    private boolean finishing = false;
    private CustomDevice device = null;

    Instance(Luwrain luwrain, MediaResourcePlayer.Listener listener) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)listener, (String)"listener");
        this.luwrain = luwrain;
        this.listener = listener;
    }

    public MediaResourcePlayer.Result play(URL url, MediaResourcePlayer.Params params) {
        if (params.playFromMsec < 0L) {
            throw new IllegalArgumentException("params.playFromMsec (" + params.playFromMsec + ") may not be negative");
        }
        if (params.volume < 0 || params.volume > 100) {
            throw new IllegalArgumentException("params.volume (" + params.volume + ") must be between 0 and 100 inclusively");
        }
        this.finishing = false;
        this.task = () -> {
            try {
                long currentFrame = 0L;
                float currentPosition = 0.0f;
                long lastNotifiedMsec = 0L;
                try (BufferedInputStream is = new BufferedInputStream(url.openStream());){
                    Bitstream bitstream;
                    Decoder decoder;
                    Instance instance = this;
                    synchronized (instance) {
                        this.device = new CustomDevice(params.volume);
                        decoder = new Decoder();
                        this.device.open(decoder);
                        bitstream = new Bitstream((InputStream)is);
                        while (currentPosition < (float)params.playFromMsec) {
                            Object frame = bitstream.readFrame();
                            if (frame == null) {
                                return;
                            }
                            currentPosition = (float)(++currentFrame) * frame.ms_per_frame();
                            bitstream.closeFrame();
                        }
                    }
                    this.listener.onPlayerTime((MediaResourcePlayer.Instance)this, new Float(currentPosition).longValue());
                    while (!this.finishing) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        Header frame = bitstream.readFrame();
                        if (frame == null) {
                            return;
                        }
                        SampleBuffer output = (SampleBuffer)decoder.decodeFrame(frame, bitstream);
                        Instance instance2 = this;
                        synchronized (instance2) {
                            this.device.write(output.getBuffer(), 0, output.getBufferLength());
                        }
                        currentPosition = (float)(++currentFrame) * frame.ms_per_frame();
                        if (currentPosition > (float)(lastNotifiedMsec + 50L)) {
                            lastNotifiedMsec = new Float(currentPosition).longValue();
                            this.listener.onPlayerTime((MediaResourcePlayer.Instance)this, lastNotifiedMsec);
                        }
                        bitstream.closeFrame();
                    }
                    return;
                }
                finally {
                    if (this.device != null) {
                        Instance instance = this;
                        synchronized (instance) {
                            this.device.flush();
                            this.device.close();
                        }
                    }
                    this.finishing = true;
                    this.listener.onPlayerFinish((MediaResourcePlayer.Instance)this);
                }
            }
            catch (Throwable e) {
                Log.error((String)LOG_COMPONENT, (String)(e.getClass().getName() + ":" + e.getMessage()));
                e.printStackTrace();
                this.finishing = true;
                if (e instanceof Exception) {
                    this.listener.onPlayerError((Exception)e);
                    return;
                }
                this.listener.onPlayerError(new Exception(e));
                return;
            }
        };
        this.luwrain.executeBkg(this.task);
        return new MediaResourcePlayer.Result();
    }

    public void setVolume(int value) {
        if (value < 0 || value > 100) {
            throw new IllegalArgumentException("value (" + value + ") must be between 0 and 100 (inclusively)");
        }
        if (this.device != null) {
            this.device.setVolume(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.finishing) {
            return;
        }
        if (this.device != null) {
            Instance instance = this;
            synchronized (instance) {
                this.device.close();
            }
        }
        this.finishing = true;
    }
}

