/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.notepad;

import org.luwrain.app.notepad.App;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.NavigationArea;
import org.luwrain.controls.edit.DefaultEditAreaAppearance;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.LineMarks;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Sounds;
import org.luwrain.nlp.SpellProblem;

abstract class Appearance
extends DefaultEditAreaAppearance {
    Appearance(ControlContext context) {
        super(context);
    }

    abstract App.Mode getMode();

    abstract EditArea getEditArea();

    public void announceLine(int index, String line) {
        LineMarks.Mark[] marks;
        String text;
        App.Mode mode = this.getMode();
        if (mode != null) {
            switch (mode) {
                case NONE: {
                    text = this.context.getSpeakableText(line, Luwrain.SpeakableTextType.NONE);
                    break;
                }
                case PROGRAMMING: {
                    text = this.context.getSpeakableText(line, Luwrain.SpeakableTextType.PROGRAMMING);
                    break;
                }
                case NATURAL: {
                    text = this.context.getSpeakableText(line, Luwrain.SpeakableTextType.NATURAL);
                    break;
                }
                default: {
                    text = line;
                    break;
                }
            }
        } else {
            text = line;
        }
        boolean hasSpellProblems = false;
        if (this.getEditArea().getContent().getLineMarks(index) != null && (marks = this.getEditArea().getContent().getLineMarks(index).getMarks()) != null) {
            for (LineMarks.Mark m : marks) {
                if (m.getMarkObject() == null || !(m.getMarkObject() instanceof SpellProblem)) continue;
                hasSpellProblems = true;
                break;
            }
        }
        if (!hasSpellProblems || line.trim().isEmpty()) {
            NavigationArea.defaultLineAnnouncement((ControlContext)this.context, (int)index, (String)text);
            return;
        }
        this.context.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.SPELLING, (String)text));
    }
}

