/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.notepad;

import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.notepad.App;
import org.luwrain.app.notepad.Narrating;
import org.luwrain.app.notepad.Strings;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.SimpleArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

final class NarratingLayout
extends LayoutBase
implements Narrating.Listener {
    private final App app;
    private final SimpleArea narratingArea;

    NarratingLayout(final App app, final Runnable closing) {
        NullCheck.notNull((Object)((Object)app), (String)"app");
        this.app = app;
        this.narratingArea = new SimpleArea((ControlContext)new DefaultControlContext(app.getLuwrain()), ((Strings)app.getStrings()).narratingAreaName()){

            public boolean onInputEvent(InputEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (app.onInputEvent((Area)this, event, closing)) {
                    return true;
                }
                return super.onInputEvent(event);
            }

            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (app.onSystemEvent((Area)this, event)) {
                    return true;
                }
                return super.onSystemEvent(event);
            }

            public boolean onAreaQuery(AreaQuery query) {
                NullCheck.notNull((Object)query, (String)"query");
                if (app.onAreaQuery((Area)this, query)) {
                    return true;
                }
                return super.onAreaQuery(query);
            }

            public void announceLine(int index, String line) {
                NullCheck.notNull((Object)line, (String)"line");
                app.getLuwrain().setEventResponse(DefaultEventResponse.text((String)app.getLuwrain().getSpeakableText(line, Luwrain.SpeakableTextType.PROGRAMMING)));
            }
        };
        this.narratingArea.add(((Strings)app.getStrings()).narratingProgress("0.0%"));
        this.narratingArea.add("");
    }

    @Override
    public void writeMessage(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        this.app.getLuwrain().runUiSafely(() -> this.narratingArea.add(this.narratingArea.getLineCount() - 2, text));
    }

    @Override
    public void progressUpdate(int sentsProcessed, int sentsTotal) {
        float value = (float)sentsProcessed * 100.0f / (float)sentsTotal;
        this.app.getLuwrain().runUiSafely(() -> this.narratingArea.setLine(this.narratingArea.getLineCount() - 2, ((Strings)this.app.getStrings()).narratingProgress(String.format("%.1f", Float.valueOf(value)) + "%")));
    }

    @Override
    public void done() {
        this.app.getLuwrain().runUiSafely(() -> {
            this.app.finishedNarrating();
            this.app.getLuwrain().onAreaNewBackgroundSound((Area)this.narratingArea);
            this.narratingArea.setLine(this.narratingArea.getLineCount() - 2, ((Strings)this.app.getStrings()).narratingDone());
            this.app.getLuwrain().message(((Strings)this.app.getStrings()).narratingDone(), Luwrain.MessageType.DONE);
        });
    }

    @Override
    public void cancelled() {
        this.app.getLuwrain().runUiSafely(() -> {
            this.app.finishedNarrating();
            this.app.getLuwrain().onAreaNewBackgroundSound((Area)this.narratingArea);
            this.narratingArea.setLine(this.narratingArea.getLineCount() - 2, ((Strings)this.app.getStrings()).narratingCancelled());
            this.app.getLuwrain().message(((Strings)this.app.getStrings()).narratingCancelled(), Luwrain.MessageType.DONE);
        });
    }

    AreaLayout getLayout() {
        return new AreaLayout((Area)this.narratingArea);
    }
}

