/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.json;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

public final class PopularMailServer {
    public static final Type LIST_TYPE = new TypeToken<List<PopularMailServer>>(){}.getType();
    private static Gson gson = null;
    private List<String> suffixes;
    private Service smtp;
    private Service pop3;

    public static String toJson(List<PopularMailServer> servers) {
        if (servers == null || servers.isEmpty()) {
            return "[]";
        }
        if (gson == null) {
            gson = new Gson();
        }
        return gson.toJson(servers);
    }

    public static List<PopularMailServer> fromJson(String str) {
        if (str == null || str.trim().isEmpty()) {
            return Arrays.asList(new PopularMailServer[0]);
        }
        if (gson == null) {
            gson = new Gson();
        }
        return (List)gson.fromJson(str, LIST_TYPE);
    }

    public static List<PopularMailServer> fromJson(Reader r) {
        if (gson == null) {
            gson = new Gson();
        }
        return (List)gson.fromJson(r, LIST_TYPE);
    }

    public List<String> getSuffixes() {
        return this.suffixes;
    }

    public Service getSmtp() {
        return this.smtp;
    }

    public Service getPop3() {
        return this.pop3;
    }

    public void setSuffixes(List<String> suffixes) {
        this.suffixes = suffixes;
    }

    public void setSmtp(Service smtp) {
        this.smtp = smtp;
    }

    public void setPop3(Service pop3) {
        this.pop3 = pop3;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PopularMailServer)) {
            return false;
        }
        PopularMailServer other = (PopularMailServer)o;
        List<String> this$suffixes = this.getSuffixes();
        List<String> other$suffixes = other.getSuffixes();
        if (this$suffixes == null ? other$suffixes != null : !((Object)this$suffixes).equals(other$suffixes)) {
            return false;
        }
        Service this$smtp = this.getSmtp();
        Service other$smtp = other.getSmtp();
        if (this$smtp == null ? other$smtp != null : !((Object)this$smtp).equals(other$smtp)) {
            return false;
        }
        Service this$pop3 = this.getPop3();
        Service other$pop3 = other.getPop3();
        return !(this$pop3 == null ? other$pop3 != null : !((Object)this$pop3).equals(other$pop3));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $suffixes = this.getSuffixes();
        result = result * 59 + ($suffixes == null ? 43 : ((Object)$suffixes).hashCode());
        Service $smtp = this.getSmtp();
        result = result * 59 + ($smtp == null ? 43 : ((Object)$smtp).hashCode());
        Service $pop3 = this.getPop3();
        result = result * 59 + ($pop3 == null ? 43 : ((Object)$pop3).hashCode());
        return result;
    }

    public String toString() {
        return "PopularMailServer(suffixes=" + String.valueOf(this.getSuffixes()) + ", smtp=" + String.valueOf(this.getSmtp()) + ", pop3=" + String.valueOf(this.getPop3()) + ")";
    }

    public static final class Service {
        private String host;
        private int port;
        private boolean ssl;
        private boolean tls;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isSsl() {
            return this.ssl;
        }

        public boolean isTls() {
            return this.tls;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setSsl(boolean ssl) {
            this.ssl = ssl;
        }

        public void setTls(boolean tls) {
            this.tls = tls;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Service)) {
                return false;
            }
            Service other = (Service)o;
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.isSsl() != other.isSsl()) {
                return false;
            }
            if (this.isTls() != other.isTls()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            result = result * 59 + (this.isSsl() ? 79 : 97);
            result = result * 59 + (this.isTls() ? 79 : 97);
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "PopularMailServer.Service(host=" + this.getHost() + ", port=" + this.getPort() + ", ssl=" + this.isSsl() + ", tls=" + this.isTls() + ")";
        }
    }
}

