/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.binder;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.TreeMap;
import org.luwrain.pim.binder.BinderStoring;
import org.luwrain.pim.binder.Case;
import org.luwrain.pim.binder.StoredCase;
import org.luwrain.pim.binder.StoredCaseSql;

class BinderStoringSql
implements BinderStoring {
    private Connection con;

    public BinderStoringSql(Connection con) {
        this.con = con;
        if (con == null) {
            throw new NullPointerException("con may not be null");
        }
    }

    @Override
    public StoredCase[] getCases() throws Exception {
        StoredCaseSql c;
        LinkedList<String> newList;
        String value;
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery("SELECT id,title,status,priority,notes FROM binder_cases ORDER BY priority");
        LinkedList<StoredCaseSql> res = new LinkedList<StoredCaseSql>();
        while (rs.next()) {
            StoredCaseSql c2 = new StoredCaseSql(this.con);
            c2.id = rs.getLong(1);
            c2.title = rs.getString(2).trim();
            c2.status = rs.getInt(3);
            c2.priority = rs.getInt(4);
            c2.tags = new String[0];
            c2.uniRefs = new String[0];
            c2.notes = rs.getString(5).trim();
            res.add(c2);
        }
        st = this.con.createStatement();
        rs = st.executeQuery("SELECT case_id,value FROM binder_case_tag");
        TreeMap treeMap = new TreeMap();
        while (rs.next()) {
            long caseId = rs.getLong(1);
            value = rs.getString(2).trim();
            if (!treeMap.containsKey(new Long(caseId))) {
                newList = new LinkedList<String>();
                newList.add(value);
                treeMap.put(new Long(caseId), newList);
                continue;
            }
            ((LinkedList)treeMap.get(new Long(caseId))).add(value);
        }
        for (StoredCase storedCase : res) {
            c = (StoredCaseSql)storedCase;
            if (!treeMap.containsKey(new Long(c.id))) continue;
            LinkedList tagsList = (LinkedList)treeMap.get(new Long(c.id));
            c.tags = tagsList.toArray(new String[tagsList.size()]);
        }
        st = this.con.createStatement();
        rs = st.executeQuery("SELECT case_id,value FROM binder_case_uniref");
        treeMap = new TreeMap();
        while (rs.next()) {
            long caseId = rs.getLong(1);
            value = rs.getString(2).trim();
            if (!treeMap.containsKey(new Long(caseId))) {
                newList = new LinkedList();
                newList.add(value);
                treeMap.put(new Long(caseId), newList);
                continue;
            }
            ((LinkedList)treeMap.get(new Long(caseId))).add(value);
        }
        for (StoredCase storedCase : res) {
            c = (StoredCaseSql)storedCase;
            if (!treeMap.containsKey(new Long(c.id))) continue;
            LinkedList uniRefsList = (LinkedList)treeMap.get(new Long(c.id));
            c.uniRefs = uniRefsList.toArray(new String[uniRefsList.size()]);
        }
        return res.toArray(new StoredCase[res.size()]);
    }

    @Override
    public void saveCase(Case c) throws Exception {
    }

    @Override
    public void deleteCase(StoredCase c) throws Exception {
    }
}

