/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.fetching;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.pim.PimException;
import org.luwrain.pim.fetching.Base;
import org.luwrain.pim.fetching.Control;
import org.luwrain.pim.fetching.FeedUtils;
import org.luwrain.pim.fetching.Strings;
import org.luwrain.pim.news.persist.Article;
import org.luwrain.pim.news.persist.Group;
import org.luwrain.pim.news.persist.NewsPersistence;

public final class News
extends Base {
    private final NewsPersistence persist;

    public News(Control control, Strings strings) {
        super(control, strings);
        this.persist = (NewsPersistence)control.luwrain().createInstance(NewsPersistence.class);
    }

    public void fetch() throws InterruptedException {
        if (this.persist == null) {
            this.message(this.strings.noNewsGroupsData());
            return;
        }
        List<Group> groups = this.persist.getGroupDAO().load();
        if (groups.isEmpty()) {
            this.message(this.strings.noNewsGroups());
            return;
        }
        for (Group g : groups) {
            this.removeOldArticles(g);
            this.checkInterrupted();
            if (!this.fetchGroup(g)) {
                return;
            }
            this.checkInterrupted();
        }
    }

    boolean fetchGroup(Group group) throws InterruptedException {
        ArrayList<Article> freshNews = new ArrayList<Article>();
        int totalCount = 0;
        List<String> urls = group.getUrls();
        if (urls != null) {
            for (String url : urls) {
                List<Article> articles;
                if (url == null || url.trim().isEmpty()) continue;
                this.checkInterrupted();
                try {
                    articles = FeedUtils.readFeed(new URL(url.trim()));
                }
                catch (MalformedURLException | PimException e) {
                    this.message(this.strings.newsFetchingError(group.getName()) + ":" + e.getMessage());
                    return true;
                }
                totalCount += articles.size();
                for (Article a : articles) {
                    if (this.persist.getArticleDAO().countByUriInGroup(group, a.getUri()) != 0) continue;
                    freshNews.add(a);
                }
            }
        }
        for (Article a : freshNews) {
            this.persist.getArticleDAO().add(group, a);
            this.checkInterrupted();
        }
        if (freshNews.size() > 0) {
            this.message(group.getName() + ": " + freshNews.size() + "/" + totalCount);
        }
        this.luwrain.sendBroadcastEvent(new SystemEvent(SystemEvent.Type.BROADCAST, SystemEvent.Code.REFRESH, "", "newsgroup:"));
        return true;
    }

    void removeOldArticles(Group group) {
        List<Article> articles = this.persist.getArticleDAO().load(group);
        for (Article a : articles) {
            if (!this.isOldArticle(a)) continue;
            this.persist.getArticleDAO().delete(group, a);
        }
    }

    boolean isOldArticle(Article article) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        Date result = cal.getTime();
        return article.getPublishedTimestamp() < result.getTime();
    }
}

