/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail.proto;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.PimException;
import org.luwrain.pim.fetching.MailConnections;
import org.luwrain.pim.mail.Message;
import org.luwrain.pim.mail.MessageProvider;
import org.luwrain.pim.mail.persistence.Account;

public final class Pop3
implements MessageProvider<ExtData> {
    private static final String LOG_COMPONENT = "pop3";
    protected final Account account;

    public Pop3(Account account) {
        NullCheck.notNull((Object)account, (String)"account");
        this.account = account;
    }

    @Override
    public void getMessages(final BiConsumer<Message, ExtData> c) {
        String name = this.account.getName();
        Log.debug((String)LOG_COMPONENT, (String)("fetching POP3 mail from: " + this.account.getName()));
        if (!this.account.isEnabled()) {
            Log.debug((String)LOG_COMPONENT, (String)("the account '" + this.account.getName() + "' is disabled"));
            return;
        }
        Log.debug((String)LOG_COMPONENT, (String)("connecting to the POP3 server:" + this.account.getHost() + ":" + this.account.getPort()));
        MailConnections con = new MailConnections(this.createMailServerParams(), true);
        Log.debug((String)LOG_COMPONENT, (String)"connection established");
        try {
            con.fetchPop3("inbox", new MailConnections.Listener(){

                @Override
                public void numberOfNewMessages(int count, boolean haveMore) {
                }

                @Override
                public boolean saveMessage(byte[] bytes, int num, int total) {
                    Message m = new Message();
                    m.setRawMessage(bytes);
                    c.accept(m, new ExtData(num, total));
                    return true;
                }
            }, !this.account.isLeaveMessages());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException e) {
            throw new PimException(e);
        }
        Log.debug((String)LOG_COMPONENT, (String)"fetching from the account finished");
    }

    MailConnections.Params createMailServerParams() {
        MailConnections.Params params = new MailConnections.Params();
        params.doAuth = !this.account.getLogin().isEmpty();
        params.host = this.account.getHost();
        params.port = this.account.getPort();
        params.ssl = this.account.isSsl();
        params.tls = this.account.isTls();
        params.login = this.account.getLogin();
        params.passwd = this.account.getPasswd();
        if (this.account.getTrustedHosts() != null && !this.account.getTrustedHosts().isEmpty()) {
            params.extProps.put("mail.pop3.ssl.trust", this.account.getTrustedHosts());
        }
        return params;
    }

    public static final class ExtData {
        public final int msgNum;
        public final int totalMsgCount;

        public ExtData(int msgNum, int totalMsgCount) {
            this.msgNum = msgNum;
            this.totalMsgCount = totalMsgCount;
        }
    }
}

