/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail.script;

import java.util.ArrayList;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.mail.persistence.Folder;
import org.luwrain.pim.mail.script.MailObj;
import org.luwrain.pim.mail.script.MessageObj;
import org.luwrain.script.ScriptUtils;
import org.luwrain.script.core.PropertiesObj;

public final class FolderObj {
    private final MailObj mailObj;
    private final Folder folder;
    @HostAccess.Export
    public ProxyExecutable getName = this::getNameImpl;
    @HostAccess.Export
    public ProxyExecutable setName = this::setNameImpl;
    @HostAccess.Export
    public ProxyExecutable getProperties = this::getPropertiesImpl;
    @HostAccess.Export
    public ProxyExecutable getSubfolders = this::getSubfoldersImpl;
    @HostAccess.Export
    public final ProxyExecutable saveMessage = this::saveMessageImpl;
    @HostAccess.Export
    public final ProxyExecutable update = this::updateImpl;
    @HostAccess.Export
    public final ProxyExecutable newSubfolder = this::newSubfolderImpl;

    FolderObj(MailObj mailObj, Folder folder) {
        NullCheck.notNull((Object)mailObj, (String)"mailObj");
        NullCheck.notNull((Object)folder, (String)"folder");
        this.mailObj = mailObj;
        this.folder = folder;
    }

    public Object getNameImpl(Value[] args) {
        return this.folder.getName();
    }

    public Object setNameImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen((Value[])args, (int)1) || !args[0].isString()) {
            throw new IllegalArgumentException("Folder.setName() takes exactly one string argument");
        }
        this.folder.setName(args[0].asString());
        return this;
    }

    public Object getPropertiesImpl(Value[] args) {
        return new PropertiesObj(this.folder.getProperties());
    }

    private Object getSubfoldersImpl(Value[] args) {
        ArrayList<FolderObj> res = new ArrayList<FolderObj>();
        for (Folder f : this.mailObj.folderDAO.getChildFolders(this.folder)) {
            res.add(new FolderObj(this.mailObj, f));
        }
        return ProxyArray.fromArray((Object[])res.toArray(new Object[res.size()]));
    }

    private Object saveMessageImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen((Value[])args, (int)1)) {
            throw new IllegalArgumentException("The first argument doesn't contain a valid message object");
        }
        MessageObj message = (MessageObj)args[0].asHostObject();
        if (message == null || message.message == null) {
            throw new IllegalArgumentException("The first argument doesn't contain a valid message object");
        }
        message.message.getMetadata().setFolderId(this.folder.getId());
        this.mailObj.messageDAO.add(message.message.getMetadata());
        return this;
    }

    private Object updateImpl(Value[] args) {
        this.mailObj.folderDAO.update(this.folder);
        return this;
    }

    private Object newSubfolderImpl(Value[] args) {
        Folder f = new Folder();
        f.setParentFolderId(this.folder.getId());
        this.mailObj.folderDAO.add(f);
        return new FolderObj(this.mailObj, f);
    }

    private Object saveProperties() {
        return false;
    }
}

