/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.lsocial;

public class Response {
    public static final String ACCOUNT_BLOCKED = "ACCOUNT_BLOCKED";
    public static final String ILLEGAL_QUERY = "ILLEGAL_QUERY";
    public static final String INTERNAL_SERVER_ERROR = "INTERNAL_SERVER_ERROR";
    public static final String LIMIT_EXCEEDED = "LIMIT_EXCEEDED";
    public static final String NOT_FOUND = "NOT_FOUND";
    public static final String NO_ACCOUNT = "NO_ACCOUNT";
    public static final String NO_PUBLICATION = "NO_PUBLICATION";
    public static final String NO_PRESENTATION = "NO_PRESENTRATION";
    public static final String PERMISSION_DENIED = "PERMISSION_DENIED";
    private Status status;
    private String errorCode;
    private String errorMessage;

    public Response() {
        this.status = Status.OK;
        this.errorCode = null;
        this.errorMessage = null;
    }

    public Response(String errorCode, String errorMessage) {
        if (errorCode == null || errorCode.trim().isEmpty()) {
            throw new IllegalArgumentException("errorCode can't be empty");
        }
        this.status = Status.ERROR;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "Response(status=" + String.valueOf((Object)this.getStatus()) + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

