/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.osm;

import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ApiClient {
    private static final String OVERPASS_API_URL = "https://maps.mail.ru/osm/tools/overpass/api/interpreter";
    private static final String NOMINATIM_API_URL = "https://nominatim.openstreetmap.org";
    private OkHttpClient client = new OkHttpClient();

    public String sendQuery(String query) throws IOException {
        Request request = new Request.Builder().url("https://maps.mail.ru/osm/tools/overpass/api/interpreter?data=" + query).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + String.valueOf(response));
            }
            String string = response.body().string();
            return string;
        }
    }

    public String sendQueryToNominatim(String query) throws IOException {
        Request request = new Request.Builder().url(NOMINATIM_API_URL + query).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + String.valueOf(response));
            }
            String string = response.body().string();
            return string;
        }
    }
}

