/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.download;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.util.Connections;

public final class Task
implements Runnable {
    private static final String LOG_COMPONENT = "download";
    private static final int MAX_ATTEMPT_COUNT = 32;
    private static final long BACKSTEP = 2048L;
    public final Callback callback;
    public final URL srcUrl;
    public File destFile;
    private URLConnection con = null;
    private Thread thread = null;
    private volatile boolean interrupting = false;

    public Task(Callback callback, URL srcUrl, File destFile) {
        NullCheck.notNull((Object)callback, (String)"callback");
        NullCheck.notNull((Object)srcUrl, (String)"srcUrl");
        NullCheck.notNull((Object)destFile, (String)"destFile");
        this.callback = callback;
        this.srcUrl = srcUrl;
        this.destFile = destFile;
    }

    public void startSync() {
        this.interrupting = false;
        try {
            for (int i = 0; i < 32; ++i) {
                if (this.interrupting) {
                    return;
                }
                try {
                    this.attempt();
                    if (!this.interrupting) {
                        this.callback.onSuccess(this);
                    }
                    return;
                }
                catch (Connections.InvalidHttpResponseCodeException e) {
                    Log.error((String)LOG_COMPONENT, (String)("downloading failed:" + ((Object)((Object)e)).getClass().getName() + ":" + e.getMessage() + " (" + this.srcUrl.toString() + ")"));
                    this.callback.onFailure(this, e);
                    return;
                }
                catch (UnknownHostException e) {
                    Log.error((String)LOG_COMPONENT, (String)("downloading failed:" + e.getClass().getName() + ":" + e.getMessage() + " (" + this.srcUrl.toString() + ")"));
                    this.callback.onFailure(this, e);
                    return;
                }
                catch (IOException e) {
                    Log.debug((String)LOG_COMPONENT, (String)("downloading attempt failed:" + e.getClass().getName() + ":" + e.getMessage() + " (" + this.srcUrl.toString() + ")"));
                    continue;
                }
            }
            this.callback.onFailure(this, new IOException("Reached the limit of attempts"));
            return;
        }
        catch (Throwable e) {
            Log.error((String)LOG_COMPONENT, (String)("downloading failed:" + e.getClass().getName() + ":" + e.getMessage() + " (" + this.srcUrl.toString() + ")"));
            if (!this.interrupting) {
                this.callback.onFailure(this, e);
            }
            return;
        }
    }

    public synchronized void startAsync() {
        if (this.thread != null) {
            throw new RuntimeException("The task is already running");
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        this.startSync();
    }

    public synchronized void stop() {
        if (this.thread == null) {
            return;
        }
        this.interrupting = true;
        URLConnection cur = this.con;
        if (cur != null) {
            try {
                cur.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                cur.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attempt() throws IOException {
        BufferedOutputStream os;
        long pos;
        if (this.destFile.exists()) {
            if (this.destFile.isDirectory()) {
                throw new RuntimeException(this.destFile.getAbsolutePath() + " exists and is a directory");
            }
            long size = this.destFile.length();
            pos = size > 2048L ? size - 2048L : 0L;
            this.truncate(pos);
            os = new BufferedOutputStream(new FileOutputStream(this.destFile, true));
        } else {
            pos = 0L;
            os = new BufferedOutputStream(new FileOutputStream(this.destFile));
        }
        if (this.interrupting) {
            return;
        }
        try {
            this.con = Connections.connect((URI)this.srcUrl.toURI(), (long)pos);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (this.interrupting) {
            return;
        }
        long len = this.con.getContentLength();
        if (len >= 0L) {
            this.callback.setFileSize(this, pos + len);
        }
        if (this.interrupting) {
            return;
        }
        InputStream is = this.con.getInputStream();
        try {
            byte[] buf = new byte[512];
            int numRead = 0;
            int totalRead = 0;
            if (this.interrupting) {
                return;
            }
            while ((numRead = is.read(buf)) >= 0) {
                if (this.interrupting) {
                    return;
                }
                os.write(buf, 0, numRead);
                this.callback.onProgress(this, pos + (long)(totalRead += numRead));
                if (!this.interrupting) continue;
                return;
            }
            if (this.interrupting) {
                return;
            }
            os.flush();
        }
        finally {
            try {
                is.close();
                os.close();
            }
            catch (IOException iOException) {}
            this.con = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncate(long pos) throws IOException {
        try (RandomAccessFile file = new RandomAccessFile(this.destFile, "rws");){
            file.setLength(pos);
        }
    }

    public static interface Callback {
        public void setFileSize(Task var1, long var2);

        public void onProgress(Task var1, long var2);

        public void onSuccess(Task var1);

        public void onFailure(Task var1, Throwable var2);
    }
}

