/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.vfs;

import java.util.Objects;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.controls.CommanderArea;
import org.luwrain.controls.CommanderUtils;
import org.luwrain.controls.ControlContext;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;

public class CommanderAppearance
implements CommanderArea.Appearance<FileObject> {
    private static final Logger log = LogManager.getLogger();
    protected final ControlContext context;
    protected final FileSystemManager manager;

    public CommanderAppearance(ControlContext context, FileSystemManager manager) {
        this.context = Objects.requireNonNull(context, "content can't be null");
        this.manager = Objects.requireNonNull(manager, "manager can't be null");
    }

    public String getCommanderName(FileObject entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        return entry.getName().getPath();
    }

    public void announceLocation(FileObject entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        if (entry.getName().getPath().equals("/")) {
            this.context.say(this.context.getStaticStr("CommanderRoot"), Sounds.COMMANDER_LOCATION);
        } else {
            this.context.say(this.context.getSpeakableText(entry.getName().getBaseName(), Luwrain.SpeakableTextType.PROGRAMMING), Sounds.COMMANDER_LOCATION);
        }
    }

    public String getEntryText(FileObject entry, CommanderArea.EntryType type, boolean marked) {
        NullCheck.notNull((Object)entry, (String)"entry");
        if (type != null && type == CommanderArea.EntryType.PARENT) {
            return "..";
        }
        return entry.getName().getBaseName();
    }

    public void announceEntry(FileObject entry, CommanderArea.EntryType type, boolean marked) {
        NullCheck.notNull((Object)entry, (String)"entry");
        NullCheck.notNull((Object)type, (String)"type");
        String name = this.context.getSpeakableText(entry.getName().getBaseName(), Luwrain.SpeakableTextType.PROGRAMMING);
        CommanderUtils.defaultEntryAnnouncement((ControlContext)this.context, (String)name, (CommanderArea.EntryType)type, (boolean)marked);
    }
}

