/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.websearch;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Luwrain;
import org.luwrain.io.websearch.Engine;
import org.luwrain.io.websearch.Entry;
import org.luwrain.io.websearch.Query;
import org.luwrain.io.websearch.Response;
import org.luwrain.popups.WebSearchPopup;

public final class WebSearch {
    private static final Logger log = LogManager.getLogger();
    final Luwrain luwrain;

    public WebSearch(Luwrain luwrain) {
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
    }

    public void searchAsync(String query, Consumer<Response> resultHandler) {
        List engines = this.luwrain.createInstances(Engine.class);
        if (engines == null || engines.isEmpty()) {
            log.error("No search engines available");
            return;
        }
        Engine eng = (Engine)engines.get(0);
        Query q = new Query();
        q.setText(query);
        this.luwrain.executeBkg(() -> {
            log.trace("Using search engine " + eng.getClass().getName());
            try {
                Response res = eng.search(q);
                this.luwrain.runUiSafely(() -> resultHandler.accept(res));
            }
            catch (IOException ex) {
                log.error("Web search failed using the engine " + eng.getClass().getName(), (Throwable)ex);
                this.luwrain.crash((Throwable)ex);
            }
        });
    }

    public void searchAsync(String query) {
        this.searchAsync(query, res -> {
            if (res == null || res.getEntries() == null || res.getEntries().isEmpty()) {
                this.luwrain.message(this.luwrain.getString("static:NothingFound"), Luwrain.MessageType.DONE);
                return;
            }
            log.trace("Obtained " + res.getEntries().size() + " search results");
            Entry entry = WebSearchPopup.open(this.luwrain, res);
            if (entry == null) {
                return;
            }
            this.onEntryClick(entry);
        });
    }

    public void onEntryClick(Entry entry) {
        if (!entry.getClickUrl().isEmpty()) {
            this.luwrain.openUrl(entry.getClickUrl());
        }
    }
}

