/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.nlp;

import dumonts.hunspell.bindings.HunspellLibrary;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bridj.NativeList;
import org.bridj.Pointer;

public final class Hunspell {
    private final Pointer<HunspellLibrary.Hunhandle> handle;
    private final Charset charset;

    public Hunspell(String dictionary, String affix) {
        try {
            Pointer aff = Pointer.pointerToCString((String)affix);
            Pointer dic = Pointer.pointerToCString((String)dictionary);
            this.handle = HunspellLibrary.Hunspell_create((Pointer)aff, (Pointer)dic);
            this.charset = Charset.forName(HunspellLibrary.Hunspell_get_dic_encoding(this.handle).getCString());
            if (this.handle == null) {
                throw new RuntimeException("Unable to create Hunspell instance");
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("Could not create hunspell instance. Please note that LanguageTool supports only 64-bit platforms (Linux, Windows, Mac) and that it requires a 64-bit JVM (Java).", e);
        }
    }

    public boolean spell(String word) {
        if (this.handle == null) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        Pointer str = Pointer.pointerToString((String)word, (Pointer.StringType)Pointer.StringType.C, (Charset)this.charset);
        int result = HunspellLibrary.Hunspell_spell(this.handle, (Pointer)str);
        return result != 0;
    }

    public void add(String word) {
        if (this.handle == null) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        Pointer str = Pointer.pointerToString((String)word, (Pointer.StringType)Pointer.StringType.C, (Charset)this.charset);
        HunspellLibrary.Hunspell_add(this.handle, (Pointer)str);
    }

    public List<String> suggest(String word) {
        Pointer str = Pointer.pointerToString((String)word, (Pointer.StringType)Pointer.StringType.C, (Charset)this.charset);
        Pointer nativeSuggestionArray = Pointer.allocatePointerPointer(Byte.class);
        int suggestionCount = HunspellLibrary.Hunspell_suggest(this.handle, (Pointer)nativeSuggestionArray, (Pointer)str);
        if (suggestionCount == 0) {
            return new ArrayList<String>();
        }
        NativeList nativeSuggestionList = ((Pointer)nativeSuggestionArray.get()).validElements((long)suggestionCount).asList();
        List<String> suggestions = nativeSuggestionList.stream().map(p -> p.getStringAtOffset(0L, Pointer.StringType.C, this.charset)).collect(Collectors.toList());
        HunspellLibrary.Hunspell_free_list(this.handle, (Pointer)nativeSuggestionArray, (int)suggestionCount);
        return suggestions;
    }

    public void close() throws IOException {
        if (this.handle != null) {
            HunspellLibrary.Hunspell_destroy(this.handle);
        }
    }
}

