/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.nlp;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

public class SpellExclusion {
    private static final String NLP_DIR = "var:luwrain.nlp";
    private static final String EXCLUSION_FILE = "spelling-exclusion.json";
    static final Type EXCLUSION_LIST_TYPE = new TypeToken<List<Exclusion>>(){}.getType();
    private final Luwrain luwrain;
    private final List<Exclusion> exclusions = new ArrayList<Exclusion>();

    public SpellExclusion(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
    }

    public List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public void load() {
        Gson gson = new Gson();
        try {
            List res;
            if (!this.getFile().exists()) {
                this.exclusions.clear();
                return;
            }
            try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFile()), "UTF-8"));){
                res = (List)gson.fromJson((Reader)r, EXCLUSION_LIST_TYPE);
            }
            this.exclusions.clear();
            if (res != null) {
                this.exclusions.addAll(res);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() {
        Gson gson = new Gson();
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getFile()), "UTF-8"));){
            gson.toJson(this.exclusions, (Appendable)w);
            w.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getFile() {
        return new File(new File(this.luwrain.getPath(NLP_DIR)), EXCLUSION_FILE);
    }

    public static final class Exclusion {
        String type = null;
        String text = null;

        public String getType() {
            return this.type != null ? this.type : "";
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getText() {
            return this.text != null ? this.text : "";
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

