/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.nlp.ru;

import java.util.HashSet;
import java.util.Set;
import org.luwrain.nlp.ru.Token;

public final class TokenPlaceholder {
    final Set<String> cyrilValues = new HashSet<String>();
    final Set<String> latinValues = new HashSet<String>();
    final Set<String> puncValues = new HashSet<String>();
    final boolean optional;

    TokenPlaceholder(Token[] tokens, boolean optional) {
        for (Token t : tokens) {
            switch (t.type) {
                case CYRIL: {
                    this.cyrilValues.add(t.text);
                }
            }
        }
        this.optional = optional;
    }

    public boolean match(Token token) {
        switch (token.type) {
            case CYRIL: {
                return this.cyrilValues.contains(token.text.toUpperCase());
            }
        }
        return false;
    }
}

