/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.contacts;

import org.luwrain.app.contacts.App;
import org.luwrain.app.contacts.Strings;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.contacts.ContactValue;
import org.luwrain.popups.Popups;

final class Conversations {
    private final App app;
    private final Luwrain luwrain;
    private final Strings strings;

    Conversations(App app) {
        NullCheck.notNull((Object)((Object)app), (String)"app");
        this.app = app;
        this.luwrain = app.getLuwrain();
        this.strings = (Strings)app.getStrings();
    }

    String newContactName() {
        return Popups.textNotEmpty((Luwrain)this.luwrain, (String)"\u041d\u043e\u0432\u044b\u0439 \u043a\u043e\u043d\u0442\u0430\u043a\u0442", (String)"\u0418\u043c\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430:", (String)"");
    }

    String newFolderName() {
        return Popups.textNotEmpty((Luwrain)this.luwrain, (String)"\u041d\u043e\u0432\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430", (String)"\u0418\u043c\u044f \u043d\u043e\u0432\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432:", (String)"");
    }

    ContactValue.Type newContactValueType() {
        String mailTitle = "\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430";
        String phoneTitle = "\u0422\u0435\u043b\u0435\u0444\u043e\u043d";
        String addressTitle = "\u0410\u0434\u0440\u0435\u0441";
        String birthdayTitle = "\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f";
        String skypeTitle = "Skype";
        Object res = Popups.fixedList((Luwrain)this.luwrain, (String)"\u0422\u0438\u043f \u043d\u043e\u0432\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f:", (Object[])new String[]{"\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430", "\u0422\u0435\u043b\u0435\u0444\u043e\u043d", "\u0410\u0434\u0440\u0435\u0441", "\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f", "Skype"});
        if (res == null) {
            return null;
        }
        if (res == "\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430") {
            return ContactValue.Type.MAIL;
        }
        if (res == "\u0410\u0434\u0440\u0435\u0441") {
            return ContactValue.Type.ADDRESS;
        }
        if (res == "\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f") {
            return ContactValue.Type.BIRTHDAY;
        }
        if (res == "Skype") {
            return ContactValue.Type.SKYPE;
        }
        return null;
    }
}

